/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysCorrectedTradingDays;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;

class CompositeCalendarCorrector
implements HolidaysCorrectedTradingDays.HolidaysCorrector {
    final HolidaysCorrectedTradingDays.HolidaysCorrector[] correctors;
    final double[] weights;

    public Matrix rawCorrection(TsDomain domain) {
        FastMatrix M = FastMatrix.of(this.correctors[0].rawCorrection(domain));
        M.mul(this.weights[0]);
        for (int i = 1; i < this.correctors.length; ++i) {
            FastMatrix cur = FastMatrix.of(this.correctors[i].rawCorrection(domain));
            M.addAY(this.weights[i], cur);
        }
        return M;
    }

    public Matrix holidaysCorrection(TsDomain domain) {
        FastMatrix M = FastMatrix.of(this.correctors[0].holidaysCorrection(domain));
        M.mul(this.weights[0]);
        for (int i = 1; i < this.correctors.length; ++i) {
            FastMatrix cur = FastMatrix.of(this.correctors[i].holidaysCorrection(domain));
            M.addAY(this.weights[i], cur);
        }
        return M;
    }

    public DoubleSeq longTermYearlyCorrection() {
        DataBlock all = DataBlock.make(7);
        all.setAY(this.weights[0], this.correctors[0].longTermYearlyCorrection());
        for (int i = 1; i < this.correctors.length; ++i) {
            all.addAY(this.weights[i], this.correctors[i].longTermYearlyCorrection());
        }
        return all;
    }

    @Generated
    public CompositeCalendarCorrector(HolidaysCorrectedTradingDays.HolidaysCorrector[] correctors, double[] weights) {
        this.correctors = correctors;
        this.weights = weights;
    }
}

