/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.transformation;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.OperationType;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.transformation.DataTransformation;
import jdplus.toolkit.base.core.data.transformation.LogJacobian;

public final class ConstTransformation
implements DataTransformation {
    private final OperationType op;
    private final double value;

    public static ConstTransformation difference(double c) {
        return new ConstTransformation(OperationType.Diff, c);
    }

    public static ConstTransformation product(double c) {
        return new ConstTransformation(OperationType.Product, c);
    }

    public static ConstTransformation ratio(double c) {
        return new ConstTransformation(OperationType.Ratio, c);
    }

    public static ConstTransformation sum(double c) {
        return new ConstTransformation(OperationType.Sum, c);
    }

    public static ConstTransformation unit(double u) {
        return new ConstTransformation(OperationType.Product, u);
    }

    public ConstTransformation(OperationType type, double val) {
        this.op = type;
        this.value = val;
    }

    @Override
    public DataTransformation converse() {
        return new ConstTransformation(this.op.reverse(), this.value);
    }

    @Override
    public DoubleSeq transform(DoubleSeq data, LogJacobian ljacobian) {
        double[] x = data.toArray();
        DataBlock X = DataBlock.of(x);
        switch (this.op) {
            case Diff: {
                X.sub(this.value);
                break;
            }
            case Product: {
                X.mul(this.value);
                if (ljacobian == null) break;
                int count = ljacobian.missing != null ? ljacobian.end - ljacobian.start - ljacobian.missing.length : X.range(ljacobian.start, ljacobian.start).count(z -> Double.isFinite(z));
                ljacobian.value += (double)count * Math.log(this.value);
                break;
            }
            case Sum: {
                X.add(this.value);
                break;
            }
            case Ratio: {
                if (this.value == 0.0) {
                    return null;
                }
                X.div(this.value);
                if (ljacobian == null) break;
                int count = ljacobian.missing != null ? ljacobian.end - ljacobian.start - ljacobian.missing.length : X.range(ljacobian.start, ljacobian.start).count(z -> Double.isFinite(z));
                ljacobian.value -= (double)count * Math.log(this.value);
                break;
            }
            default: {
                return data;
            }
        }
        return DoubleSeq.of((double[])x);
    }

    @Override
    public double transform(double x) {
        switch (this.op) {
            case Diff: {
                return x - this.value;
            }
            case Product: {
                return x * this.value;
            }
            case Sum: {
                return x + this.value;
            }
            case Ratio: {
                if (this.value == 0.0) {
                    return Double.NaN;
                }
                return x / this.value;
            }
        }
        return x;
    }
}

