/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.bool;

import choco.cp.solver.constraints.integer.bool.BooleanFactory;
import choco.cp.solver.constraints.integer.channeling.ReifiedLargeOr;
import choco.cp.solver.constraints.reified.leaves.bool.AbstractBoolNode;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class OrNode
extends AbstractBoolNode
implements BoolNode {
    public OrNode(INode ... subt) {
        super(subt, NodeType.OR);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        for (INode subtree : this.subtrees) {
            if (!((BoolNode)((Object)subtree)).checkTuple(tuple)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        if (vs.length > 1) {
            IntDomainVar v = s.createBooleanVar(StringUtils.randomName());
            IntDomainVar[] vars = ArrayUtils.append({v}, vs);
            s.post(new ReifiedLargeOr(vars, s.getEnvironment()));
            return v;
        }
        return vs[0];
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        return BooleanFactory.or(s.getEnvironment(), vs);
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuffer st = new StringBuffer("(");
        for (i = 0; i < this.subtrees.length - 1; ++i) {
            st.append(this.subtrees[i].pretty()).append(" or ");
        }
        st.append(this.subtrees[i].pretty()).append(")");
        return st.toString();
    }
}

