## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE  # Set to FALSE since these are 'shiny' examples
)

## ----setup--------------------------------------------------------------------
# library(linkeR)
# library(shiny)
# library(leaflet)
# library(DT)

## ----map-module---------------------------------------------------------------
# # /path/to/your/app/map_module.R
# 
# #' Map Module UI
# #'
# #' @param id A character string. The namespace ID.
# #' @return A UI definition.
# mapUI <- function(id) {
#   ns <- NS(id)
#   leafletOutput(ns("wastewater_map"), height = "500px")
# }
# 
# #' Map Module Server
# #'
# #' @param id A character string. The namespace ID.
# #' @param data A reactive expression returning the data for the map.
# #' @param registry A link_registry object for managing component linking.
# mapServer <- function(id, data, registry) {
#   moduleServer(id, function(input, output, session) {
# 
#     # Register this component with the central registry
#     register_leaflet(
#       session = session, # <-- Pass the module's session for namespacing
#       registry = registry,
#       leaflet_output_id = "wastewater_map", # <-- The local ID within this module
#       data_reactive = data,
#       shared_id_column = "id",
#       click_handler = function(map_proxy, selected_data, session) { # <-- click handler must have map_proxy, selected_data, session, overrides all default behavior
#         print("The leaflet map component was just clicked!")
#       }
#     )
# 
#     output$wastewater_map <- renderLeaflet({
#       # ... leaflet rendering logic ...
#     })
#   })
# }

## ----table-module-------------------------------------------------------------
# # /path/to/your/app/table_module.R
# 
# #' Table Module UI
# #'
# #' @param id A character string. The namespace ID.
# #' @return A UI definition.
# tableUI <- function(id) {
#   ns <- NS(id)
#   DTOutput(ns("wastewater_table"))
# }
# 
# #' Table Module Server
# #'
# #' @param id A character string. The namespace ID.
# #' @param data A reactive expression returning the data for the table.
# #' @param registry A link_registry object for managing component linking.
# tableServer <- function(id, data, registry) {
#   moduleServer(id, function(input, output, session) {
# 
#     # Register this component with the central registry
#     register_dt(
#       session = session, # <-- Pass the module's session
#       registry = registry,
#       dt_output_id = "wastewater_table", # <-- The local ID
#       data_reactive = data,
#       shared_id_column = "id",
#       click_handler = function(map_proxy, selected_data, session) { # <-- click handler must have map_proxy, selected_data, session, overrides all default behavior
#         print("The DT table component was just clicked!")
#       }
#     )
# 
#     output$wastewater_table <- renderDT({
#       # ... datatable rendering logic ...
#     })
#   })
# }

## ----main-app-----------------------------------------------------------------
# # /path/to/your/app/app.R
# 
# library(shiny)
# library(leaflet)
# library(DT)
# library(linkeR)
# 
# # Source the modules
# source("map_module.R")
# source("table_module.R")
# 
# # --- UI ---
# ui <- fluidPage(
#   titlePanel("linkeR Modular Linking Example"),
#   fluidRow(
#     column(7,
#       h4("Wastewater Map (Module 1)"),
#       mapUI("map_module")
#     ),
#     column(5,
#       h4("Facility Data (Module 2)"),
#       tableUI("table_module")
#     )
#   )
# )
# 
# # --- Server ---
# server <- function(input, output, session) {
# 
#   # --- 1. Create the central link registry ---
#   registry <- create_link_registry(session)
# 
#   # Shared reactive data
#   wastewater_data <- reactive({
#     # ... data generation logic ...
#   })
# 
#   # --- 2. Pass the registry to each module server ---
#   mapServer("map_module", wastewater_data, registry)
#   tableServer("table_module", wastewater_data, registry)
# }
# 
# shinyApp(ui, server)

