/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.stat.Frequency;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataRecordIteration;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.FilteringDataRecordIterator;
import org.vikamine.kernel.data.IncludingDataRecordFilter;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.statistics.ChiSquareStatistics;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SupportingFactor;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.subgroup.target.SelectorTarget;

public class SGUtils {
    public static double calculateChi2ValueBetweenSelectorAndTarget(SGNominalSelector sel, SGNominalSelector target, DataView population, Options options) {
        SG sg = new SG(population, new SelectorTarget(target));
        SGDescription sgd = new SGDescription();
        sgd.add(sel);
        sg.setSGDescription(sgd);
        sg.createStatistics(options);
        SGStatisticsBinary statistics = (SGStatisticsBinary)sg.getStatistics();
        return SGUtils.calculateChi2OfSubgroup(statistics);
    }

    public static double calculateChi2OfSubgroup(SGStatisticsBinary sgStatistics) {
        double positives = sgStatistics.getPositives();
        double tp = sgStatistics.getTp();
        double fp = sgStatistics.getFp();
        double sgSize = sgStatistics.getSubgroupSize();
        double fn = positives - tp;
        double populationSize = sgStatistics.getDefinedPopulationCount();
        double tn = populationSize - sgSize - fn;
        return ChiSquareStatistics.computeFourFoldChiSqare(tp, fn, fp, tn);
    }

    public static double calculateChi2Significance(SGStatisticsBinary sgStatistics) {
        double chi2Value = SGUtils.calculateChi2OfSubgroup(sgStatistics);
        return SGUtils.calculateChi2SignificanceNiveau(chi2Value, 1);
    }

    public static double calculateChi2SignificanceNiveau(double chi2Value, int degreesOfFreedom) {
        ChiSquaredDistribution distr = new ChiSquaredDistribution(degreesOfFreedom);
        try {
            return 1.0 - distr.cumulativeProbability(chi2Value);
        }
        catch (MaxCountExceededException e) {
            Logger.getLogger(SGUtils.class.getName()).warning(e.getMessage());
            return Double.NaN;
        }
    }

    public static double getChi2SignificanceNiveau(double tp, double fp, double tn, double fn) {
        double chi2Value = ChiSquareStatistics.computeFourFoldChiSqare(tp, fp, tn, fn);
        return SGUtils.calculateChi2SignificanceNiveau(chi2Value, 1);
    }

    public static String toDiscretizedChi2SignificanceLevel(double sigNiveau) {
        String level = "";
        double[] levels = new double[]{1.0E-6, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.05, 0.1, 0.2, 0.5, 0.8, 1.0};
        int i = 0;
        while (i < levels.length) {
            if (sigNiveau <= levels[i]) {
                NumberFormat nFormat = NumberFormat.getInstance();
                nFormat.setMaximumFractionDigits(6);
                level = "<=" + nFormat.format(levels[i]);
                break;
            }
            ++i;
        }
        level.equals("");
        return level;
    }

    public static String createChi2SignificanceString(double value) {
        DecimalFormat formatter = value > 0.01 ? new DecimalFormat("0.00") : (value > 1.0E-4 ? new DecimalFormat("0.0000") : (value > 1.0E-12 ? new DecimalFormat("0.0000########") : new DecimalFormat("0.00E0")));
        return formatter.format(value);
    }

    public static String createUSChi2SignificanceStringForXSL(double value) {
        NumberFormat f = NumberFormat.getInstance(Locale.US);
        if (!(f instanceof DecimalFormat)) {
            return Double.toString(value);
        }
        DecimalFormat formatter = (DecimalFormat)f;
        if (value > 0.01) {
            formatter.applyPattern("0.00");
        } else if (value > 1.0E-4) {
            formatter.applyPattern("0.0000");
        } else if (value > 1.0E-12) {
            formatter.applyPattern("0.0000########");
        } else {
            formatter.applyPattern("0.00E0");
        }
        return formatter.format(value);
    }

    public static List<SupportingFactor> computeSupportingFactors(SG subgroup, List dmAttributes) {
        return SGUtils.computeSupportingFactors(subgroup, dmAttributes, false);
    }

    private static DataRecordIteration getNonClassPopulationIteration(SG subgroup) {
        return new DataRecordIteration(new FilteringDataRecordIterator(subgroup.getPopulation().instanceIterator(), new PosNegInstanceFilter(false, subgroup)));
    }

    public static List<SupportingFactor> computeSupportingFactors(SG subgroup, List dmAttributes, boolean includePrincipalFactors) {
        DataRecordIteration subgroupInstanceIteration = new DataRecordIteration(subgroup.subgroupInstanceIterator());
        return SGUtils.computeSupportingFactors(subgroup, dmAttributes, includePrincipalFactors, subgroupInstanceIteration);
    }

    private static double[] accumulateSupportingCounts(Iterator<DataRecord> instanceIterator, SGNominalSelector supportingSGSelector, SG subgroup) {
        double contained = 0.0;
        double notContained = 0.0;
        while (instanceIterator.hasNext()) {
            DataRecord instance = instanceIterator.next();
            if (!subgroup.getStatistics().isAttributeDefinedInInstance(instance, supportingSGSelector.getAttribute())) continue;
            if (supportingSGSelector.isContainedInInstance(instance)) {
                contained += 1.0;
                continue;
            }
            notContained += 1.0;
        }
        return new double[]{contained, notContained};
    }

    public static List<SupportingFactor> computeSupportingFactors(SG subgroup, List dmAttributes, boolean includePrincipalFactors, DataRecordIteration instanceIteration) {
        DataRecordIteration tpInstanceIteration = new DataRecordIteration(new FilteringDataRecordIterator(instanceIteration.iterator(), new PosNegInstanceFilter(true, subgroup)));
        DataRecordIteration nonClassPopulationIteration = SGUtils.getNonClassPopulationIteration(subgroup);
        LinkedList<SupportingFactor> result = new LinkedList<SupportingFactor>();
        for (Attribute attribute : dmAttributes) {
            if (!attribute.isNominal() || !SGUtils.isAttributeDependentChi2WithValues(tpInstanceIteration, nonClassPopulationIteration, (NominalAttribute)attribute)) continue;
            Iterator<Value> iterator = ((NominalAttribute)attribute).allValuesIterator();
            while (iterator.hasNext()) {
                double phi;
                double chi2Threshold;
                boolean isSignificant;
                double[] negativeCounts;
                Value val = iterator.next();
                DefaultSGSelector supportingFactorSelector = new DefaultSGSelector(attribute, val);
                double[] positiveCounts = SGUtils.accumulateSupportingCounts(tpInstanceIteration.iterator(), supportingFactorSelector, subgroup);
                double chi2 = ChiSquareStatistics.computeFourFoldChiSqare(positiveCounts[0], positiveCounts[1], (negativeCounts = SGUtils.accumulateSupportingCounts(nonClassPopulationIteration.iterator(), supportingFactorSelector, subgroup))[0], negativeCounts[1]);
                boolean bl = isSignificant = chi2 > (chi2Threshold = SGUtils.determineChi2Threshold(2));
                if (!isSignificant || !includePrincipalFactors && subgroup.getSGDescription().containsAttributeAsSelector(attribute) || subgroup.getTarget().getAttributes().contains(attribute) || !((phi = ChiSquareStatistics.computePhiCoefficient(positiveCounts[0], positiveCounts[1], negativeCounts[0], negativeCounts[1])) > 0.0)) continue;
                result.add(new SupportingFactor(supportingFactorSelector, positiveCounts[0], positiveCounts[1], negativeCounts[0], negativeCounts[1], phi));
            }
        }
        return result;
    }

    private static boolean isAttributeDependentChi2WithValues(DataRecordIteration positiveInstanceIteration, DataRecordIteration negativeInstanceIteration, NominalAttribute attribute) {
        LinkedList<Integer> tpDistributionValues = new LinkedList<Integer>();
        LinkedList<Integer> ncDistributionValues = new LinkedList<Integer>();
        boolean tpKey = false;
        boolean ncKey = true;
        int[] totals = new int[2];
        int admissibleValueCounter = 0;
        Iterator<Value> iterator = attribute.allValuesIterator();
        while (iterator.hasNext()) {
            Value val = iterator.next();
            DefaultSGSelector factor = new DefaultSGSelector((Attribute)attribute, Collections.singleton(val));
            int countTPInstances = 0;
            for (DataRecord instance : positiveInstanceIteration) {
                if (!factor.isContainedInInstance(instance)) continue;
                ++countTPInstances;
            }
            int countNCInstances = 0;
            for (DataRecord instance : negativeInstanceIteration) {
                if (!factor.isContainedInInstance(instance)) continue;
                ++countNCInstances;
            }
            if (countTPInstances == 0 && countNCInstances == 0) continue;
            ++admissibleValueCounter;
            tpDistributionValues.add(countTPInstances);
            totals[0] = totals[0] + countTPInstances;
            ncDistributionValues.add(countNCInstances);
            totals[1] = totals[1] + countNCInstances;
        }
        int tpAndNCSumKey = 2;
        int[][] distributionArray = new int[3][admissibleValueCounter];
        int i = 0;
        while (i < admissibleValueCounter) {
            distributionArray[0][i] = (Integer)tpDistributionValues.get(i);
            distributionArray[1][i] = (Integer)ncDistributionValues.get(i);
            distributionArray[2][i] = distributionArray[0][i] + distributionArray[1][i];
            ++i;
        }
        int total = totals[0] + totals[1];
        boolean isSignificant = false;
        if (admissibleValueCounter >= 2) {
            double chi2 = 0.0;
            double sum = 0.0;
            int i2 = 0;
            while (i2 < 2) {
                int j = 0;
                while (j < admissibleValueCounter) {
                    sum += Math.pow(distributionArray[i2][j], 2.0) / (double)(totals[i2] * distributionArray[2][j]);
                    ++j;
                }
                ++i2;
            }
            chi2 = (double)total * (sum - 1.0);
            double chi2Threshold = SGUtils.determineChi2Threshold(admissibleValueCounter);
            isSignificant = chi2 > chi2Threshold;
        }
        return isSignificant;
    }

    private static double determineChi2Threshold(int admissibleValueCounter) {
        double[] chi2ThresholdsForDegreesOfFreedomStrictSIGLevel = new double[]{0.0, 6.63, 9.21, 11.34, 13.28, 15.09, 16.81, 18.48, 20.09, 21.67, 23.21, 24.72, 26.22, 27.69, 29.14, 30.58, 32.0, 33.41, 34.81, 36.19, 37.57, 38.93, 40.29, 41.64, 42.98, 44.31, 45.64, 46.96, 48.28};
        double[] chi2ThresholdsForDegreesOfFreedomNormalSIGLevel = new double[]{0.0, 3.84, 5.99, 7.81, 0.49, 11.07, 12.59, 14.07, 15.51, 16.92, 18.31, 19.68, 21.03, 22.36, 23.68, 25.0, 26.3, 27.59, 28.87, 30.14, 31.41, 32.67, 33.92, 35.17, 36.42, 37.65, 38.89, 40.11, 41.34, 42.56, 43.77};
        double chi2Threshold = 0.0;
        int degreesOfFreedom = admissibleValueCounter - 1;
        chi2Threshold = degreesOfFreedom >= chi2ThresholdsForDegreesOfFreedomStrictSIGLevel.length ? chi2ThresholdsForDegreesOfFreedomNormalSIGLevel[chi2ThresholdsForDegreesOfFreedomNormalSIGLevel.length - 1] : chi2ThresholdsForDegreesOfFreedomNormalSIGLevel[degreesOfFreedom];
        return chi2Threshold;
    }

    public static double computeOddsRatio(SGStatisticsBinary sgStats) {
        double tp = sgStats.getTp();
        double fp = sgStats.getFp();
        double fn = sgStats.getFn();
        double tn = sgStats.getTn();
        if (tp == 0.0 || fp == 0.0 || fn == 0.0 || tn == 0.0) {
            return 0.0;
        }
        double oddsRatio = tp * tn / (fp * fn);
        return oddsRatio;
    }

    public static double computeStandardDeviation(double base, double[] vals) {
        double stdev = 0.0;
        int i = 0;
        while (i < vals.length) {
            double val = vals[i];
            stdev += Math.pow(base - val, 2.0);
            ++i;
        }
        return Math.sqrt(stdev / (double)(vals.length - 1));
    }

    public static double computeMean(double[] values) {
        double mean = 0.0;
        int i = 0;
        while (i < values.length) {
            mean += values[i];
            ++i;
        }
        return mean / (double)values.length;
    }

    public static double computeQualityStandardDeviation(SG sg, List strataSGs, IQualityFunction qf) {
        double baseQuality = qf.evaluate(sg);
        double[] vals = new double[strataSGs.size()];
        int i = 0;
        for (SG stratumSG : strataSGs) {
            double q;
            vals[i] = q = qf.evaluate(stratumSG);
            ++i;
        }
        double meanQualityDeviation = SGUtils.computeStandardDeviation(baseQuality, vals);
        return meanQualityDeviation;
    }

    public static double computeOddsRatioStandardDeviation(SG sg, List strataSGs) {
        double baseQuality = SGUtils.computeOddsRatio((SGStatisticsBinary)sg.getStatistics());
        double[] vals = new double[strataSGs.size()];
        int i = 0;
        for (SG stratumSG : strataSGs) {
            double q;
            vals[i] = q = SGUtils.computeOddsRatio((SGStatisticsBinary)stratumSG.getStatistics());
            ++i;
        }
        double stdDeviationOddsRatio = SGUtils.computeStandardDeviation(baseQuality, vals);
        return stdDeviationOddsRatio;
    }

    public static boolean isAttributeAssociatedWithSGDescription(NominalAttribute att, SG sg) {
        if (!att.isNominal()) {
            return false;
        }
        LinkedList<DataRecord> positiveInstances = new LinkedList<DataRecord>();
        LinkedList<DataRecord> negativeInstances = new LinkedList<DataRecord>();
        Iterator<DataRecord> iter = sg.getPopulation().instanceIterator();
        while (iter.hasNext()) {
            DataRecord instance = iter.next();
            if (!sg.getStatistics().isSGSelectorSetDefinedInInstance(instance)) continue;
            if (sg.getSGDescription().isMatching(instance)) {
                positiveInstances.add(instance);
                continue;
            }
            negativeInstances.add(instance);
        }
        return SGUtils.isAttributeDependentChi2WithValues(new DataRecordIteration(positiveInstances.iterator()), new DataRecordIteration(negativeInstances.iterator()), att);
    }

    private static double[] getValuesOfAttribute(SG subgroup, Attribute a) {
        double[] result = new double[(int)subgroup.getStatistics().getSubgroupSize()];
        int i = 0;
        for (DataRecord record : subgroup) {
            double val;
            result[i] = val = record.getValue(a);
            ++i;
        }
        return result;
    }

    public static double computeMean(Attribute a, SG subgroup) {
        double[] valuesOfAttribute = SGUtils.getValuesOfAttribute(subgroup, a);
        return SGUtils.computeMean(valuesOfAttribute);
    }

    public static double computeStandardDeviation(Attribute a, SG subgroup) {
        double[] valuesOfAttribute = SGUtils.getValuesOfAttribute(subgroup, a);
        double mean = SGUtils.computeMean(valuesOfAttribute);
        return SGUtils.computeStandardDeviation(mean, valuesOfAttribute);
    }

    public static DescriptiveStatistics createDescriptiveStats(Iterable<DataRecord> newInput, NumericAttribute att) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (DataRecord dr : newInput) {
            double value = dr.getValue(att);
            if (Value.isMissingValue(value)) continue;
            stats.addValue(value);
        }
        return stats;
    }

    public static Frequency createFrequencyStats(Iterable<DataRecord> newInput, Attribute att) {
        Frequency stats = new Frequency();
        for (DataRecord dr : newInput) {
            stats.addValue(Double.valueOf(dr.getValue(att)));
        }
        return stats;
    }

    private static class PosNegInstanceFilter
    implements IncludingDataRecordFilter {
        private final boolean positive;
        private final SG sg;

        PosNegInstanceFilter(boolean positive, SG sg) {
            this.positive = positive;
            this.sg = sg;
        }

        @Override
        public boolean isIncluded(DataRecord theInstance) {
            SGTarget target = this.sg.getTarget();
            if (this.sg.getStatistics().isInstanceDefinedForSubgroupVars(theInstance)) {
                boolean containsTarget = false;
                if (target instanceof BooleanTarget) {
                    containsTarget = ((BooleanTarget)target).isPositive(theInstance);
                } else if (target == null) {
                    containsTarget = true;
                } else {
                    throw new UnsupportedOperationException("No other targets, such as " + target + ", besides BooleanTargets are supported yet!");
                }
                return containsTarget == this.positive;
            }
            return false;
        }
    }
}

