/*
 * Decompiled with CFR 0.152.
 */
package com.musigma.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.common.InvalidConfigException;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.message.MessageAndMetadata;
import org.I0Itec.zkclient.exception.ZkTimeoutException;

public class MuConsumer {
    private List<String> messagesList;
    private ConsumerIterator<byte[], byte[]> it;
    private ConsumerConnector consumerConnector;

    public void CreateConsumer(String zookeeperConnect, String groupId, String zookeeperConnectionTimeoutMs, String consumerTimeoutMs, String autoCommitEnable, String autoCommitIntervalMs, String autoOffsetReset) {
        try {
            Properties properties = new Properties();
            properties.put("zookeeper.connect", zookeeperConnect);
            properties.put("group.id", groupId);
            properties.put("zookeeper.connection.timeout.ms", zookeeperConnectionTimeoutMs);
            properties.put("consumer.timeout.ms", consumerTimeoutMs);
            if (!"NULL".equalsIgnoreCase(autoCommitEnable)) {
                properties.put("auto.commit.enable", autoCommitEnable);
            }
            if (!"NULL".equalsIgnoreCase(autoCommitIntervalMs)) {
                System.out.println("Setting auto offset");
            }
            if (!"NULL".equalsIgnoreCase(autoOffsetReset)) {
                properties.put("auto.offset.reset", autoOffsetReset);
            }
            ConsumerConfig consumerConfig = new ConsumerConfig(properties);
            this.consumerConnector = Consumer.createJavaConsumerConnector(consumerConfig);
        }
        catch (NumberFormatException e) {
            System.out.println("Please check all consumer properties passed");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println("Please check all consumer properties passed");
            e.printStackTrace();
        }
        catch (ZkTimeoutException e) {
            System.out.println("Unable to connect to zookeeper server");
            e.printStackTrace();
        }
        catch (InvalidConfigException e) {
            System.out.println("Invalid value set for consumer properties. Please check all consumer properties passed");
            e.printStackTrace();
        }
    }

    public boolean startConsumer(String topicName) {
        boolean success2 = true;
        try {
            try {
                HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
                topicCountMap.put(topicName, new Integer(1));
                Map<String, List<KafkaStream<byte[], byte[]>>> consumerMap = this.consumerConnector.createMessageStreams(topicCountMap);
                KafkaStream<byte[], byte[]> stream = consumerMap.get(topicName).get(0);
                this.it = stream.iterator();
                this.messagesList = new ArrayList<String>();
            }
            catch (ConsumerTimeoutException ex) {
                System.out.println("No new messages pushed within timeout threshold");
                success2 = false;
            }
            catch (UnknownTopicOrPartitionException e) {
                System.out.println("Unknown topic or partition");
                success2 = false;
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                System.out.println("Please check all parameters passed");
                success2 = false;
                e.printStackTrace();
            }
            catch (Exception e) {
                success2 = false;
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return success2;
    }

    public String tail() {
        String message = "";
        try {
            try {
                if (this.it.hasNext()) {
                    message = new String((byte[])((MessageAndMetadata)this.it.next()).message());
                }
            }
            catch (NullPointerException ex) {
                System.out.println("Message empty");
            }
            catch (ConsumerTimeoutException ex) {
                System.out.println("No new messages pushed within timeout threshold");
            }
            catch (UnknownTopicOrPartitionException e) {
                System.out.println("Unknown topic or partition");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                System.out.println("Please check all parameters passed");
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return message;
    }

    public String[] poll() {
        this.messagesList.clear();
        try {
            try {
                while (this.it.hasNext()) {
                    this.messagesList.add(new String((byte[])((MessageAndMetadata)this.it.next()).message()));
                }
            }
            catch (NullPointerException ex) {
                System.out.println("Message empty");
            }
            catch (ConsumerTimeoutException ex) {
                System.out.println("No new messages pushed within timeout threshold");
            }
            catch (UnknownTopicOrPartitionException e) {
                System.out.println("Unknown topic or partition");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                System.out.println("Please check all parameters passed");
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        String[] msgs = new String[this.messagesList.size()];
        msgs = this.messagesList.toArray(msgs);
        return msgs;
    }

    public void close() {
        this.consumerConnector.shutdown();
    }
}

