/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.parser.ParserModelLoader;
import opennlp.tools.cmdline.postag.POSModelLoader;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.postag.POSModel;

public final class TaggerModelReplacerTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "replaces the tagger model in a parser model";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " parser.model tagger.model";
    }

    public void run(String[] args) {
        if (args.length != 2) {
            System.out.println(this.getHelp());
        } else {
            File parserModelInFile = new File(args[0]);
            ParserModel parserModel = (ParserModel)new ParserModelLoader().load(parserModelInFile);
            File taggerModelInFile = new File(args[1]);
            POSModel taggerModel = (POSModel)new POSModelLoader().load(taggerModelInFile);
            ParserModel updatedParserModel = parserModel.updateTaggerModel(taggerModel);
            CmdLineUtil.writeModel("parser", parserModelInFile, updatedParserModel);
        }
    }
}

