/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.formats.BioNLP2004NameSampleStreamFactory;
import opennlp.tools.formats.ChunkerSampleStreamFactory;
import opennlp.tools.formats.Conll02NameSampleStreamFactory;
import opennlp.tools.formats.Conll03NameSampleStreamFactory;
import opennlp.tools.formats.ConllXPOSSampleStreamFactory;
import opennlp.tools.formats.ConllXSentenceSampleStreamFactory;
import opennlp.tools.formats.ConllXTokenSampleStreamFactory;
import opennlp.tools.formats.CorefSampleStreamFactory;
import opennlp.tools.formats.DocumentSampleStreamFactory;
import opennlp.tools.formats.LeipzigDocumentSampleStreamFactory;
import opennlp.tools.formats.NameSampleDataStreamFactory;
import opennlp.tools.formats.ParseSampleStreamFactory;
import opennlp.tools.formats.SentenceSampleStreamFactory;
import opennlp.tools.formats.TokenSampleStreamFactory;
import opennlp.tools.formats.WordTagSampleStreamFactory;
import opennlp.tools.formats.ad.ADChunkSampleStreamFactory;
import opennlp.tools.formats.ad.ADNameSampleStreamFactory;
import opennlp.tools.formats.ad.ADPOSSampleStreamFactory;
import opennlp.tools.formats.ad.ADSentenceSampleStreamFactory;
import opennlp.tools.formats.ad.ADTokenSampleStreamFactory;
import opennlp.tools.formats.convert.NameToSentenceSampleStreamFactory;
import opennlp.tools.formats.convert.NameToTokenSampleStreamFactory;
import opennlp.tools.formats.convert.POSToSentenceSampleStreamFactory;
import opennlp.tools.formats.convert.POSToTokenSampleStreamFactory;
import opennlp.tools.formats.convert.ParseToPOSSampleStreamFactory;
import opennlp.tools.formats.convert.ParseToSentenceSampleStreamFactory;
import opennlp.tools.formats.convert.ParseToTokenSampleStreamFactory;
import opennlp.tools.formats.frenchtreebank.ConstitParseSampleStreamFactory;
import opennlp.tools.formats.muc.Muc6FullParseCorefSampleStreamFactory;
import opennlp.tools.formats.muc.Muc6NameSampleStreamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamFactoryRegistry {
    private static final Map<Class, Map<String, ObjectStreamFactory>> registry = new HashMap<Class, Map<String, ObjectStreamFactory>>();
    public static final String DEFAULT_FORMAT = "opennlp";

    private StreamFactoryRegistry() {
    }

    public static boolean registerFactory(Class sampleClass, String formatName, ObjectStreamFactory factory) {
        boolean result;
        Map<String, ObjectStreamFactory> formats = registry.get(sampleClass);
        if (null == formats) {
            formats = new HashMap<String, ObjectStreamFactory>();
        }
        if (!formats.containsKey(formatName)) {
            formats.put(formatName, factory);
            registry.put(sampleClass, formats);
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public static void unregisterFactory(Class sampleClass, String formatName) {
        Map<String, ObjectStreamFactory> formats = registry.get(sampleClass);
        if (null != formats && formats.containsKey(formatName)) {
            formats.remove(formatName);
        }
    }

    public static <T> Map<String, ObjectStreamFactory<T>> getFactories(Class<T> sampleClass) {
        return registry.get(sampleClass);
    }

    public static <T> ObjectStreamFactory<T> getFactory(Class<T> sampleClass, String formatName) {
        ObjectStreamFactory factory;
        if (null == formatName) {
            formatName = DEFAULT_FORMAT;
        }
        ObjectStreamFactory objectStreamFactory = factory = registry.containsKey(sampleClass) ? registry.get(sampleClass).get(formatName) : null;
        if (factory != null) {
            return factory;
        }
        try {
            Class<?> factoryClazz = Class.forName(formatName);
            try {
                return (ObjectStreamFactory)factoryClazz.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        ChunkerSampleStreamFactory.registerFactory();
        DocumentSampleStreamFactory.registerFactory();
        NameSampleDataStreamFactory.registerFactory();
        ParseSampleStreamFactory.registerFactory();
        SentenceSampleStreamFactory.registerFactory();
        TokenSampleStreamFactory.registerFactory();
        WordTagSampleStreamFactory.registerFactory();
        CorefSampleStreamFactory.registerFactory();
        NameToSentenceSampleStreamFactory.registerFactory();
        NameToTokenSampleStreamFactory.registerFactory();
        POSToSentenceSampleStreamFactory.registerFactory();
        POSToTokenSampleStreamFactory.registerFactory();
        ParseToPOSSampleStreamFactory.registerFactory();
        ParseToSentenceSampleStreamFactory.registerFactory();
        ParseToTokenSampleStreamFactory.registerFactory();
        BioNLP2004NameSampleStreamFactory.registerFactory();
        Conll02NameSampleStreamFactory.registerFactory();
        Conll03NameSampleStreamFactory.registerFactory();
        ConllXPOSSampleStreamFactory.registerFactory();
        ConllXSentenceSampleStreamFactory.registerFactory();
        ConllXTokenSampleStreamFactory.registerFactory();
        LeipzigDocumentSampleStreamFactory.registerFactory();
        ADChunkSampleStreamFactory.registerFactory();
        ADNameSampleStreamFactory.registerFactory();
        ADSentenceSampleStreamFactory.registerFactory();
        ADPOSSampleStreamFactory.registerFactory();
        ADTokenSampleStreamFactory.registerFactory();
        Muc6NameSampleStreamFactory.registerFactory();
        Muc6FullParseCorefSampleStreamFactory.registerFactory();
        ConstitParseSampleStreamFactory.registerFactory();
    }
}

