/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.tests;

import cc.mallet.types.MatrixOps;
import cc.mallet.util.QR;
import org.junit.Assert;
import org.junit.Test;

public class TestQR {
    @Test
    public void testQR() {
        double[][] A = new double[][]{{0.3023496, -0.2352895, -0.08332658}, {1.1871093, 0.4090436, 0.18437203}, {0.5707067, -1.0149112, 1.14817968}};
        double[][] Q = new double[][]{{0.2237265, -0.186961, -0.9565522}, {0.8784129, 0.4639149, 0.114777}, {0.4222999, -0.8659264, 0.268019}};
        double[][] R = new double[][]{{1.351425, -0.1219282, 0.6281886}, {0.0, 1.1125898, -0.8931274}, {0.0, 0.0, 0.4086019}};
        QR decomposition = new QR(MatrixOps.deepClone(A));
        MatrixOps.print(decomposition.getQ());
        MatrixOps.print(Q);
        double diff = MatrixOps.sumSquaredDiff(decomposition.getQ(), Q);
        Assert.assertEquals(0.0, diff, 0.01);
        MatrixOps.print(decomposition.getR());
        MatrixOps.print(R);
        diff = MatrixOps.sumSquaredDiff(decomposition.getR(), R);
        Assert.assertEquals(0.0, diff, 0.01);
        double[][] product = MatrixOps.aTimesB(decomposition.getQ(), decomposition.getR());
        diff = MatrixOps.sumSquaredDiff(A, product);
        Assert.assertEquals(0.0, diff, 0.01);
    }
}

