/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.utilities.KNN;

import java.util.HashMap;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class KNN {
    protected static int K = 1;

    public static void setK(int n) {
        K = n;
    }

    public static int k() {
        return K;
    }

    public static int getK() {
        return KNN.k();
    }

    public static Prototype _1nn(Prototype current, PrototypeSet dataSet) {
        Prototype nearestNeighbor = (Prototype)dataSet.get(0);
        int indexNN = 0;
        double minDist = Double.POSITIVE_INFINITY;
        int _size = dataSet.size();
        for (int i = 0; i < _size; ++i) {
            Prototype pi = (Prototype)dataSet.get(i);
            double currDist = Distance.euclideanDistance(pi, current);
            if (!(currDist > 0.0) || !(currDist < minDist)) continue;
            minDist = currDist;
            indexNN = i;
        }
        return (Prototype)dataSet.get(indexNN);
    }

    public static PrototypeSet knn(Prototype current, PrototypeSet dataSet, int k) {
        PrototypeSet nneighbors = new PrototypeSet(k);
        PrototypeSet sorted = dataSet.sort(current);
        for (int i = 0; i < k; ++i) {
            nneighbors.add(sorted.get(i));
        }
        return nneighbors;
    }

    public static PrototypeSet knn(Prototype current, PrototypeSet dataSet) {
        return KNN.knn(current, dataSet, K);
    }

    public static int classficationAccuracy1NN(PrototypeSet training, PrototypeSet test) {
        int wellClassificated = 0;
        for (Prototype p : test) {
            Prototype nearestNeighbor = KNN._1nn(p, training);
            if (p.getOutput(0) != nearestNeighbor.getOutput(0)) continue;
            ++wellClassificated;
        }
        return wellClassificated;
    }

    public static Pair<Integer, Integer> classficationAccuracyAndError1NN(PrototypeSet training, PrototypeSet test) {
        int wellClassificated = 0;
        int notWellClassif = 0;
        for (Prototype p : test) {
            Prototype nearestNeighbor = KNN._1nn(p, training);
            ++notWellClassif;
            if (p.label() != nearestNeighbor.label()) continue;
            ++wellClassificated;
            --notWellClassif;
        }
        return new Pair<Integer, Integer>(wellClassificated, notWellClassif);
    }

    public static int classficationAccuracy(PrototypeSet training, PrototypeSet test, int k) {
        int wellClassificated = 0;
        for (Prototype p : test) {
            PrototypeSet neighbors = KNN.knn(p, training, k);
            HashMap<Double, Integer> classes = new HashMap<Double, Integer>();
            double maximumKey = -1.0;
            int maximumTimes = -1;
            int i = 0;
            for (Prototype n : neighbors) {
                double class_n = n.firstOutput();
                ++i;
                if (!classes.containsKey(class_n)) {
                    if (maximumKey == -1.0) {
                        maximumKey = class_n;
                    }
                    classes.put(class_n, 1);
                    continue;
                }
                int num_n = (Integer)classes.get(class_n) + 1;
                classes.put(class_n, num_n);
                if (num_n > maximumTimes) {
                    maximumTimes = num_n;
                    maximumKey = class_n;
                    continue;
                }
                if (num_n != maximumTimes || !(RandomGenerator.RanddoubleClosed(0.0, 1.0) > 0.5)) continue;
                maximumKey = class_n;
            }
            if (maximumKey != p.firstOutput()) continue;
            ++wellClassificated;
        }
        return wellClassificated;
    }

    public static int classficationAccuracy(PrototypeSet training, PrototypeSet test) {
        return KNN.classficationAccuracy(training, test, K);
    }

    public static Prototype getNearest(Prototype current, PrototypeSet dataSet, boolean isSameClass) {
        if (isSameClass) {
            return KNN.getNearestWithSameClassAs(current, dataSet);
        }
        return KNN.getNearestWithDifferentClassAs(current, dataSet);
    }

    public static Prototype getNearest(Prototype current, PrototypeSet dataSet) {
        return dataSet.nearestTo(current);
    }

    public static Prototype getNearestWithSameClassAs(Prototype current, PrototypeSet dataSet) {
        double label = current.label();
        PrototypeSet dataSetOfLabel = dataSet.getFromClass(label);
        if (dataSetOfLabel.isEmpty()) {
            Debug.errorln("There are no prototypes of class " + label);
            return null;
        }
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        for (Prototype p : dataSetOfLabel) {
            double d = Distance.d(current, p);
            if (!(d < dMin) || current == p) continue;
            dMin = d;
            nearest = p;
        }
        return nearest;
    }

    public static PrototypeSet getNearestNeighborsWithSameClassAs(Prototype current, PrototypeSet dataSet) {
        PrototypeSet neighborsWithSameClass = new PrototypeSet();
        PrototypeSet sorted = dataSet.sort(current);
        double class_current = current.label();
        for (Prototype p : sorted) {
            if (p.label() != class_current) continue;
            neighborsWithSameClass.add(p);
        }
        return neighborsWithSameClass;
    }

    public static PrototypeSet getNearestNeighborsWithSameClassAs(Prototype current, PrototypeSet dataSet, int numberOfNeighbors) {
        PrototypeSet neighborsWithSameClass = new PrototypeSet();
        PrototypeSet sorted = dataSet.sort(current);
        double class_current = current.label();
        int _size = sorted.size();
        boolean full = false;
        int counter = 0;
        for (int i = 0; i < _size && !full; ++i) {
            if (((Prototype)sorted.get(i)).label() != class_current) continue;
            neighborsWithSameClass.add(sorted.get(i));
            full = counter == numberOfNeighbors;
            ++counter;
        }
        return neighborsWithSameClass;
    }

    public static PrototypeSet getNearestNeighborsWithDifferentClassAs(Prototype current, PrototypeSet dataSet, int numberOfNeighbors) {
        PrototypeSet nn = new PrototypeSet();
        PrototypeSet sorted = dataSet.sort(current);
        double class_current = current.label();
        int _size = sorted.size();
        boolean full = false;
        int counter = 0;
        for (int i = 0; i < _size && !full; ++i) {
            if (((Prototype)sorted.get(i)).label() == class_current) continue;
            nn.add(sorted.get(i));
            full = counter == numberOfNeighbors;
            ++counter;
        }
        return nn;
    }

    public static Prototype getNearestWithDifferentClassAs(Prototype current, PrototypeSet dataSet) {
        double label = current.label();
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        for (Prototype p : dataSet) {
            double d = Distance.d(current, p);
            if (!(d < dMin) || p.label() == label || current == p || current.equals(p)) continue;
            dMin = d;
            nearest = p;
        }
        return nearest;
    }

    public static PrototypeSet getNearestNeighbors(Prototype current, PrototypeSet dataSet, int numberOfNeighbors) {
        PrototypeSet nn = new PrototypeSet();
        PrototypeSet sorted = dataSet.sort(current);
        int _size = sorted.size();
        boolean full = false;
        int counter = 0;
        for (int i = 0; i < _size && !full; ++i) {
            nn.add(sorted.get(i));
            full = counter == numberOfNeighbors;
            ++counter;
        }
        return nn;
    }
}

