/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.Logistic.core.matrix;

import java.util.Arrays;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.matrix.FlexibleDecimalFormat;

public class IntVector
implements Cloneable {
    int[] V;
    private int sizeOfVector;

    public IntVector() {
        this.V = new int[0];
        this.setSize(0);
    }

    public IntVector(int n) {
        this.V = new int[n];
        this.setSize(n);
    }

    public IntVector(int n, int s) {
        this(n);
        this.set(s);
    }

    public IntVector(int[] v) {
        if (v == null) {
            this.V = new int[0];
            this.setSize(0);
        } else {
            this.V = new int[v.length];
            this.setSize(v.length);
            this.set(0, this.size() - 1, v, 0);
        }
    }

    public int size() {
        return this.sizeOfVector;
    }

    public void setSize(int size) {
        if (size > this.capacity()) {
            throw new IllegalArgumentException("insufficient capacity");
        }
        this.sizeOfVector = size;
    }

    public void set(int s) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, s);
        }
    }

    public void set(int i0, int i1, int[] v, int j0) {
        for (int i = i0; i <= i1; ++i) {
            this.set(i, v[j0 + i - i0]);
        }
    }

    public void set(int i0, int i1, IntVector v, int j0) {
        for (int i = i0; i <= i1; ++i) {
            this.set(i, v.get(j0 + i - i0));
        }
    }

    public void set(IntVector v) {
        this.set(0, v.size() - 1, v, 0);
    }

    public static IntVector seq(int i0, int i1) {
        if (i1 < i0) {
            throw new IllegalArgumentException("i1 < i0 ");
        }
        IntVector v = new IntVector(i1 - i0 + 1);
        for (int i = 0; i < i1 - i0 + 1; ++i) {
            v.set(i, i + i0);
        }
        return v;
    }

    public int[] getArray() {
        return this.V;
    }

    protected void setArray(int[] a) {
        this.V = a;
    }

    public void sort() {
        Arrays.sort(this.V, 0, this.size());
    }

    public int[] getArrayCopy() {
        int[] b = new int[this.size()];
        for (int i = 0; i <= this.size() - 1; ++i) {
            b[i] = this.V[i];
        }
        return b;
    }

    public int capacity() {
        return this.V.length;
    }

    public void setCapacity(int capacity) {
        if (capacity == this.capacity()) {
            return;
        }
        int[] old_V = this.V;
        int m = Math.min(capacity, this.size());
        this.V = new int[capacity];
        this.setSize(capacity);
        this.set(0, m - 1, old_V, 0);
    }

    public void set(int i, int s) {
        this.V[i] = s;
    }

    public int get(int i) {
        return this.V[i];
    }

    public IntVector copy() {
        return (IntVector)this.clone();
    }

    public Object clone() {
        IntVector u = new IntVector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            u.V[i] = this.V[i];
        }
        return u;
    }

    public IntVector subvector(int i0, int i1) {
        IntVector v = new IntVector(i1 - i0 + 1);
        v.set(0, i1 - i0, this, i0);
        return v;
    }

    public IntVector subvector(IntVector index) {
        IntVector v = new IntVector(index.size());
        for (int i = 0; i < index.size(); ++i) {
            v.V[i] = this.V[index.V[i]];
        }
        return v;
    }

    public void swap(int i, int j) {
        if (i == j) {
            return;
        }
        int t = this.get(i);
        this.set(i, this.get(j));
        this.set(j, t);
    }

    public void shift(int i, int j) {
        if (i == j) {
            return;
        }
        if (i < j) {
            int t = this.V[i];
            for (int k = i; k <= j - 1; ++k) {
                this.V[k] = this.V[k + 1];
            }
            this.V[j] = t;
        } else {
            this.shift(j, i);
        }
    }

    public void shiftToEnd(int j) {
        this.shift(j, this.size() - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int digits, boolean trailing) {
        if (this.isEmpty()) {
            return "null vector";
        }
        StringBuffer text = new StringBuffer();
        FlexibleDecimalFormat nf = new FlexibleDecimalFormat(digits, trailing);
        nf.grouping(true);
        for (int i = 0; i < this.size(); ++i) {
            nf.update(this.get(i));
        }
        int count = 0;
        int width = 80;
        for (int i = 0; i < this.size(); ++i) {
            String number = nf.format(this.get(i));
            if ((count += 1 + number.length()) > width - 1) {
                text.append('\n');
                count = 1 + number.length();
            }
            text.append(" " + number);
        }
        return text.toString();
    }

    public static void main(String[] args) {
        IntVector u = new IntVector();
        System.out.println(u);
        IntVector v = IntVector.seq(10, 25);
        System.out.println(v);
        IntVector w = IntVector.seq(25, 10);
        System.out.println(w);
    }
}

