/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Clas.listener;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import keel.Algorithms.Neural_Networks.NNEP_Clas.algorithm.classification.CCRElitistNeuralNetAlgorithm;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.IClassifier;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax.ClassificationProblemEvaluator;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax.ISoftmaxClassifier;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.errorfunctions.ClassificationAccuracyErrorFunction;
import keel.Algorithms.Neural_Networks.NNEP_Common.NeuralNetIndividual;
import keel.Algorithms.Neural_Networks.NNEP_Common.algorithm.NeuralNetAlgorithm;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.ParametricMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.ParametricSRMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuralNet;
import keel.Algorithms.Neural_Networks.NNEP_Common.problem.ProblemEvaluator;
import net.sf.jclec.AlgorithmEvent;
import net.sf.jclec.IAlgorithmListener;
import net.sf.jclec.IEvaluator;
import net.sf.jclec.base.AbstractIndividual;

public class NeuralNetReporterClas
implements IAlgorithmListener<NeuralNetAlgorithm<NeuralNetIndividual>> {
    private static final long serialVersionUID = 873929825900558241L;
    private ClassificationAccuracyErrorFunction caErrorFunction = new ClassificationAccuracyErrorFunction();
    private String header;
    private String trainResultFile;
    private String testResultFile;
    private String bestModelResultFile;
    private IAttribute outputAttribute;

    @Override
    public void algorithmStarted(AlgorithmEvent<NeuralNetAlgorithm<NeuralNetIndividual>> event) {
        this.doIterationReport(event.getAlgorithm());
    }

    @Override
    public void algorithmFinished(AlgorithmEvent<NeuralNetAlgorithm<NeuralNetIndividual>> event) {
        try {
            int predictedClass;
            int observedClass;
            int i;
            NeuralNetAlgorithm<NeuralNetIndividual> algorithm = event.getAlgorithm();
            PrintWriter print = new PrintWriter(new FileWriter(this.trainResultFile));
            print.write(this.header);
            DoubleTransposedDataSet dataset = ((ProblemEvaluator)event.getAlgorithm().getEvaluator()).getTrainData();
            double[][] observedOutputs = dataset.getAllOutputs();
            CCRElitistNeuralNetAlgorithm elitistAlgorithm = (CCRElitistNeuralNetAlgorithm)algorithm;
            ISoftmaxClassifier bestClassifier = (ISoftmaxClassifier)((AbstractIndividual)elitistAlgorithm.getBestCCRIndividual()).getGenotype();
            byte[][] predictedOutputs = bestClassifier.classify(dataset.getAllInputs());
            for (i = 0; i < dataset.getNofobservations(); ++i) {
                observedClass = 1;
                while (observedOutputs[observedClass - 1][i] != 1.0) {
                    ++observedClass;
                }
                print.write(this.outputAttribute.show(observedClass) + " ");
                predictedClass = 1;
                while (predictedOutputs[predictedClass - 1][i] != 1) {
                    ++predictedClass;
                }
                print.write(this.outputAttribute.show(predictedClass) + "\n");
            }
            print.close();
            print = new PrintWriter(new FileWriter(this.testResultFile));
            print.write(this.header);
            dataset = ((ProblemEvaluator)event.getAlgorithm().getEvaluator()).getTestData();
            observedOutputs = dataset.getAllOutputs();
            predictedOutputs = bestClassifier.classify(dataset.getAllInputs());
            for (i = 0; i < dataset.getNofobservations(); ++i) {
                observedClass = 1;
                while (observedOutputs[observedClass - 1][i] != 1.0) {
                    ++observedClass;
                }
                print.write(this.outputAttribute.show(observedClass) + " ");
                predictedClass = 1;
                while (predictedOutputs[predictedClass - 1][i] != 1) {
                    ++predictedClass;
                }
                print.write(this.outputAttribute.show(predictedClass) + "\n");
            }
            print.close();
            print = new PrintWriter(new FileWriter(this.bestModelResultFile));
            int generation = algorithm.getGeneration();
            ParametricMutator parametricMutator = null;
            if (algorithm.getMutator1() instanceof ParametricMutator) {
                parametricMutator = (ParametricMutator)algorithm.getMutator1();
            } else if (algorithm.getMutator2() instanceof ParametricMutator) {
                parametricMutator = (ParametricMutator)algorithm.getMutator2();
            }
            print.write(this.renderGeneration(generation, (AbstractIndividual)elitistAlgorithm.getBestIndividual(), (AbstractIndividual<INeuralNet>)elitistAlgorithm.getBestCCRIndividual(), parametricMutator, algorithm.getEvaluator()));
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file: " + e.getMessage());
        }
    }

    @Override
    public void iterationCompleted(AlgorithmEvent<NeuralNetAlgorithm<NeuralNetIndividual>> event) {
        this.doIterationReport(event.getAlgorithm());
    }

    public String getBestModelResultFile() {
        return this.bestModelResultFile;
    }

    public void setBestModelResultFile(String bestModelResultFile) {
        this.bestModelResultFile = bestModelResultFile;
    }

    public String getTestResultFile() {
        return this.testResultFile;
    }

    public void setTestResultFile(String testResultFile) {
        this.testResultFile = testResultFile;
    }

    public String getTrainResultFile() {
        return this.trainResultFile;
    }

    public void setTrainResultFile(String trainResultFile) {
        this.trainResultFile = trainResultFile;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public IAttribute getOutputAttribute() {
        return this.outputAttribute;
    }

    public void setOutputAttribute(IAttribute outputAttribute) {
        this.outputAttribute = outputAttribute;
    }

    public void doIterationReport(NeuralNetAlgorithm<NeuralNetIndividual> algorithm) {
        int generation = algorithm.getGeneration();
        ParametricMutator parametricMutator = null;
        if (algorithm.getMutator1() instanceof ParametricMutator) {
            parametricMutator = (ParametricMutator)algorithm.getMutator1();
        } else if (algorithm.getMutator2() instanceof ParametricMutator) {
            parametricMutator = (ParametricMutator)algorithm.getMutator2();
        }
        this.printGeneration(generation, algorithm.getBestIndividual(), (AbstractIndividual<INeuralNet>)((CCRElitistNeuralNetAlgorithm)algorithm).getBestCCRIndividual(), parametricMutator, algorithm.getEvaluator());
        System.out.println("Generations without improving ==> Best: " + algorithm.getNogbest() + " ( " + algorithm.getCurrentBest() + " / " + algorithm.getPreviousBest() + " )" + "\n                                  Mean: " + algorithm.getNogmean() + " ( " + algorithm.getCurrentMean() + " / " + algorithm.getPreviousMean() + " )\n");
    }

    public void printGeneration(int nofgeneration, AbstractIndividual<INeuralNet> bestNnind, AbstractIndividual<INeuralNet> bestCCRNnind, ParametricMutator<NeuralNetIndividual> parametricMutator, IEvaluator evaluator) {
        System.out.println(this.renderGeneration(nofgeneration, bestNnind, bestCCRNnind, parametricMutator, evaluator));
    }

    protected String renderGeneration(int nofgeneration, AbstractIndividual<INeuralNet> bestNnind, AbstractIndividual<INeuralNet> bestCCRNnind, ParametricMutator<NeuralNetIndividual> parametricMutator, IEvaluator evaluator) {
        String result = "Generation " + nofgeneration + "\n";
        if (bestCCRNnind != null) {
            result = result + "=> Best CCR Individual:\n";
            result = result + this.renderNeuralNetIndividual(bestCCRNnind, evaluator);
        } else {
            result = result + "=> Best Fitness Individual:\n";
            result = result + this.renderNeuralNetIndividual(bestNnind, evaluator);
        }
        if (parametricMutator != null) {
            result = result + "AlphaInput " + parametricMutator.getAlphaInput() + " AlphaOutput " + parametricMutator.getAlphaOutput();
        }
        if (parametricMutator instanceof ParametricSRMutator) {
            result = result + " Success Ratio " + ((ParametricSRMutator)parametricMutator).getSuccessRatio();
        }
        return result;
    }

    protected String renderNeuralNetIndividual(AbstractIndividual<INeuralNet> nnind, IEvaluator evaluator) {
        String result = nnind.toString();
        result = result + "\n";
        result = result + "Number of hidden neurons: " + nnind.getGenotype().getNofhneurons();
        result = result + " Number of effective links: " + nnind.getGenotype().getNoflinks() + "\n";
        IClassifier classifier = (IClassifier)((Object)nnind.getGenotype());
        result = result + "Train CCR: " + ((ClassificationProblemEvaluator)evaluator).getTrainClassificationError(classifier, this.caErrorFunction) + "\n";
        result = result + "Test  CCR: " + ((ClassificationProblemEvaluator)evaluator).getTestClassificationError(classifier, this.caErrorFunction) + "\n";
        return result;
    }
}

