/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.ArithmeticMod;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class MRG32k3aL
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final long m1 = 0xFFFFFF2FL;
    private static final long m2 = 4294944443L;
    private static final long a12 = 1403580L;
    private static final long a13n = 810728L;
    private static final long a21 = 527612L;
    private static final long a23n = 1370589L;
    private static final long two17 = 131072L;
    private static final long two53 = 0x20000000000000L;
    private static final double invtwo24 = 5.960464477539063E-8;
    private static final double norm = 2.328306549295728E-10;
    private static final long[][] A1p0 = new long[][]{{0L, 1L, 0L}, {0L, 0L, 1L}, {-810728L, 1403580L, 0L}};
    private static final long[][] A2p0 = new long[][]{{0L, 1L, 0L}, {0L, 0L, 1L}, {-1370589L, 0L, 527612L}};
    private static final long[][] A1p76 = new long[][]{{82758667L, 1871391091L, 4127413238L}, {3672831523L, 69195019L, 1871391091L}, {3672091415L, 3528743235L, 69195019L}};
    private static final long[][] A2p76 = new long[][]{{1511326704L, 3759209742L, 1610795712L}, {4292754251L, 1511326704L, 3889917532L}, {3859662829L, 4292754251L, 3708466080L}};
    private static final long[][] A1p127 = new long[][]{{2427906178L, 3580155704L, 949770784L}, {226153695L, 1230515664L, 3580155704L}, {1988835001L, 986791581L, 1230515664L}};
    private static final long[][] A2p127 = new long[][]{{1464411153L, 277697599L, 1610723613L}, {32183930L, 1464411153L, 1022607788L}, {2824425944L, 32183930L, 2093834863L}};
    private static long[] nextSeed = new long[]{12345L, 12345L, 12345L, 12345L, 12345L, 12345L};
    private long Cg0;
    private long Cg1;
    private long Cg2;
    private long Cg3;
    private long Cg4;
    private long Cg5;
    private long[] Bg = new long[6];
    private long[] Ig = new long[6];

    private static void multMatVect(long[] lArray, long[][] lArray2, long l, long[][] lArray3, long l2) {
        int n;
        long[] lArray4 = new long[3];
        for (n = 0; n < 3; ++n) {
            lArray4[n] = lArray[n];
        }
        ArithmeticMod.matVecModM(lArray2, lArray4, lArray4, l);
        for (n = 0; n < 3; ++n) {
            lArray[n] = lArray4[n];
        }
        for (n = 0; n < 3; ++n) {
            lArray4[n] = lArray[n + 3];
        }
        ArithmeticMod.matVecModM(lArray3, lArray4, lArray4, l2);
        for (n = 0; n < 3; ++n) {
            lArray[n + 3] = lArray4[n];
        }
    }

    public MRG32k3aL() {
        this.name = null;
        this.anti = false;
        this.prec53 = false;
        for (int i = 0; i < 6; ++i) {
            this.Ig[i] = nextSeed[i];
        }
        this.resetStartStream();
        MRG32k3aL.multMatVect(nextSeed, A1p127, 0xFFFFFF2FL, A2p127, 4294944443L);
    }

    public MRG32k3aL(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(long[] lArray) {
        if (lArray.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (lArray[0] == 0L && lArray[1] == 0L && lArray[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (lArray[5] == 0L && lArray[3] == 0L && lArray[4] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (lArray[0] >= 0xFFFFFF2FL || lArray[1] >= 0xFFFFFF2FL || lArray[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        if (lArray[5] >= 4294944443L || lArray[3] >= 4294944443L || lArray[4] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
        for (int i = 0; i < 6; ++i) {
            MRG32k3aL.nextSeed[i] = lArray[i];
        }
    }

    public void setSeed(long[] lArray) {
        if (lArray.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (lArray[0] == 0L && lArray[1] == 0L && lArray[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (lArray[3] == 0L && lArray[4] == 0L && lArray[5] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (lArray[0] >= 0xFFFFFF2FL || lArray[1] >= 0xFFFFFF2FL || lArray[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        if (lArray[3] >= 4294944443L || lArray[4] >= 4294944443L || lArray[5] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
        for (int i = 0; i < 6; ++i) {
            this.Ig[i] = lArray[i];
        }
        this.resetStartStream();
    }

    public void resetStartStream() {
        for (int i = 0; i < 6; ++i) {
            this.Bg[i] = this.Ig[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.Cg0 = this.Bg[0];
        this.Cg1 = this.Bg[1];
        this.Cg2 = this.Bg[2];
        this.Cg3 = this.Bg[3];
        this.Cg4 = this.Bg[4];
        this.Cg5 = this.Bg[5];
    }

    public void resetNextSubstream() {
        MRG32k3aL.multMatVect(this.Bg, A1p76, 0xFFFFFF2FL, A2p76, 4294944443L);
        this.resetStartSubstream();
    }

    public long[] getState() {
        return new long[]{this.Cg0, this.Cg1, this.Cg2, this.Cg3, this.Cg4, this.Cg5};
    }

    public String toString() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("The current state of the MRG32k3aL");
        if (this.name != null && this.name.length() > 0) {
            printfFormat.append(" " + this.name);
        }
        printfFormat.append(":\n   Cg = { ");
        printfFormat.append(this.Cg0 + ", ");
        printfFormat.append(this.Cg1 + ", ");
        printfFormat.append(this.Cg2 + ", ");
        printfFormat.append(this.Cg3 + ", ");
        printfFormat.append(this.Cg4 + ", ");
        printfFormat.append(this.Cg5 + " }\n\n");
        return printfFormat.toString();
    }

    public String toStringFull() {
        int n;
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("The MRG32k3aL stream");
        if (this.name != null && this.name.length() > 0) {
            printfFormat.append(" " + this.name);
        }
        printfFormat.append(":\n   anti = " + (this.anti ? "true" : "false")).append('\n');
        printfFormat.append("   prec53 = " + (this.prec53 ? "true" : "false")).append('\n');
        printfFormat.append("   Ig = { ");
        for (n = 0; n < 5; ++n) {
            printfFormat.append(this.Ig[n] + ", ");
        }
        printfFormat.append(this.Ig[5] + " }\n");
        printfFormat.append("   Bg = { ");
        for (n = 0; n < 5; ++n) {
            printfFormat.append(this.Bg[n] + ", ");
        }
        printfFormat.append(this.Bg[5] + " }\n");
        printfFormat.append("   Cg = { ");
        printfFormat.append(this.Cg0 + ", ");
        printfFormat.append(this.Cg1 + ", ");
        printfFormat.append(this.Cg2 + ", ");
        printfFormat.append(this.Cg3 + ", ");
        printfFormat.append(this.Cg4 + ", ");
        printfFormat.append(this.Cg5 + " }\n\n");
        return printfFormat.toString();
    }

    public MRG32k3aL clone() {
        MRG32k3aL mRG32k3aL = null;
        mRG32k3aL = (MRG32k3aL)super.clone();
        mRG32k3aL.Bg = new long[6];
        mRG32k3aL.Ig = new long[6];
        for (int i = 0; i < 6; ++i) {
            mRG32k3aL.Bg[i] = this.Bg[i];
            mRG32k3aL.Ig[i] = this.Ig[i];
        }
        return mRG32k3aL;
    }

    protected double nextValue() {
        long l = (1403580L * this.Cg1 - 810728L * this.Cg0) % 0xFFFFFF2FL;
        if (l < 0L) {
            l += 0xFFFFFF2FL;
        }
        this.Cg0 = this.Cg1;
        this.Cg1 = this.Cg2;
        this.Cg2 = l;
        long l2 = (527612L * this.Cg5 - 1370589L * this.Cg3) % 4294944443L;
        if (l2 < 0L) {
            l2 += 4294944443L;
        }
        this.Cg3 = this.Cg4;
        this.Cg4 = this.Cg5;
        this.Cg5 = l2;
        return l > l2 ? (double)(l - l2) * 2.328306549295728E-10 : (double)(l - l2 + 0xFFFFFF2FL) * 2.328306549295728E-10;
    }
}

