/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatFunctions;
import java.io.Serializable;

public class DenseFloatCholeskyDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private FloatMatrix2D L;
    private FloatMatrix2D Lt;
    private int n;
    private boolean isSymmetricPositiveDefinite;

    public DenseFloatCholeskyDecomposition(FloatMatrix2D floatMatrix2D) {
        int n;
        FloatProperty.DEFAULT.checkSquare(floatMatrix2D);
        this.n = floatMatrix2D.rows();
        this.L = floatMatrix2D.like(this.n, this.n);
        this.isSymmetricPositiveDefinite = floatMatrix2D.columns() == this.n;
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[this.n];
        for (n = 0; n < this.n; ++n) {
            floatMatrix1DArray[n] = this.L.viewRow(n);
        }
        for (n = 0; n < this.n; ++n) {
            int n2;
            float f = 0.0f;
            for (n2 = 0; n2 < n; ++n2) {
                float f2 = floatMatrix1DArray[n2].zDotProduct(floatMatrix1DArray[n], 0, n2);
                f2 = (floatMatrix2D.getQuick(n, n2) - f2) / this.L.getQuick(n2, n2);
                floatMatrix1DArray[n].setQuick(n2, f2);
                f += f2 * f2;
                this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && floatMatrix2D.getQuick(n2, n) == floatMatrix2D.getQuick(n, n2);
            }
            f = floatMatrix2D.getQuick(n, n) - f;
            this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && (double)f > 0.0;
            this.L.setQuick(n, n, (float)Math.sqrt(Math.max((double)f, 0.0)));
            for (n2 = n + 1; n2 < this.n; ++n2) {
                this.L.setQuick(n, n2, 0.0f);
            }
        }
        this.Lt = this.L.viewDice().copy();
    }

    public FloatMatrix2D getL() {
        return this.L;
    }

    public FloatMatrix2D getLtranspose() {
        return this.Lt;
    }

    public boolean isSymmetricPositiveDefinite() {
        return this.isSymmetricPositiveDefinite;
    }

    public FloatMatrix2D solve(FloatMatrix2D floatMatrix2D) {
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.copy();
        int n = floatMatrix2D.columns();
        for (int i = 0; i < n; ++i) {
            int n2;
            float f;
            int n3;
            for (n3 = 0; n3 < this.n; ++n3) {
                f = floatMatrix2D.getQuick(n3, i);
                for (n2 = n3 - 1; n2 >= 0; --n2) {
                    f -= this.L.getQuick(n3, n2) * floatMatrix2D2.getQuick(n2, i);
                }
                floatMatrix2D2.setQuick(n3, i, f / this.L.getQuick(n3, n3));
            }
            for (n3 = this.n - 1; n3 >= 0; --n3) {
                f = floatMatrix2D2.getQuick(n3, i);
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    f -= this.L.getQuick(n2, n3) * floatMatrix2D2.getQuick(n2, i);
                }
                floatMatrix2D2.setQuick(n3, i, f / this.L.getQuick(n3, n3));
            }
        }
        return floatMatrix2D2;
    }

    public FloatMatrix1D solve(FloatMatrix1D floatMatrix1D) {
        int n;
        float f;
        int n2;
        FloatMatrix1D floatMatrix1D2 = floatMatrix1D.copy();
        for (n2 = 0; n2 < this.n; ++n2) {
            f = floatMatrix1D.getQuick(n2);
            for (n = n2 - 1; n >= 0; --n) {
                f -= this.L.getQuick(n2, n) * floatMatrix1D2.getQuick(n);
            }
            floatMatrix1D2.setQuick(n2, f / this.L.getQuick(n2, n2));
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            f = floatMatrix1D2.getQuick(n2);
            for (n = n2 + 1; n < this.n; ++n) {
                f -= this.L.getQuick(n, n2) * floatMatrix1D2.getQuick(n);
            }
            floatMatrix1D2.setQuick(n2, f / this.L.getQuick(n2, n2));
        }
        return floatMatrix1D2;
    }

    private FloatMatrix2D XXXsolveBuggy(FloatMatrix2D floatMatrix2D) {
        int n;
        int n2;
        FloatFunctions floatFunctions = FloatFunctions.functions;
        if (floatMatrix2D.rows() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isSymmetricPositiveDefinite) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.copy();
        int n3 = floatMatrix2D.columns();
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[this.n];
        for (n2 = 0; n2 < this.n; ++n2) {
            floatMatrix1DArray[n2] = floatMatrix2D2.viewRow(n2);
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = n2 + 1; n < this.n; ++n) {
                floatMatrix1DArray[n].assign(floatMatrix1DArray[n2], FloatFunctions.minusMult(this.L.getQuick(n, n2)));
            }
            floatMatrix1DArray[n2].assign(FloatFunctions.div(this.L.getQuick(n2, n2)));
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            floatMatrix1DArray[n2].assign(FloatFunctions.div(this.L.getQuick(n2, n2)));
            for (n = 0; n < n2; ++n) {
                floatMatrix1DArray[n].assign(floatMatrix1DArray[n2], FloatFunctions.minusMult(this.L.getQuick(n2, n)));
            }
        }
        return floatMatrix2D2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("--------------------------------------------------------------------------\n");
        stringBuffer.append("CholeskyDecomposition(A) --> isSymmetricPositiveDefinite(A), L, inverse(A)\n");
        stringBuffer.append("--------------------------------------------------------------------------\n");
        stringBuffer.append("isSymmetricPositiveDefinite = ");
        try {
            stringBuffer.append(String.valueOf(this.isSymmetricPositiveDefinite()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nL = ");
        try {
            stringBuffer.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\ninverse(A) = ");
        try {
            stringBuffer.append(String.valueOf(this.solve(FloatFactory2D.dense.identity(this.L.rows()))));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

