/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.jayes.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.recommenders.jayes.factor.AbstractFactor;
import org.eclipse.recommenders.jayes.util.MathUtils;

public final class AddressCalc {
    private AddressCalc() {
    }

    public static void incrementMultiDimensionalCounter(int[] counter, int[] dimensions) {
        int dimension;
        int n = dimension = counter.length - 1;
        counter[n] = counter[n] + 1;
        while (counter[dimension] == dimensions[dimension]) {
            counter[dimension] = 0;
            int n2 = --dimension;
            counter[n2] = counter[n2] + 1;
        }
    }

    public static int[] computeLinearMap(AbstractFactor factor, int ... dimensionIDs) {
        return AddressCalc.computeLinearMap(AddressCalc.computeIdToDimensionIndexMap(factor), factor.getDimensions(), dimensionIDs);
    }

    private static int[] computeLinearMap(Map<Integer, Integer> foreignIdToIndex, int[] foreignDimensions, int[] dimensionIds) {
        int[] kernel = new int[dimensionIds.length];
        int i = 0;
        while (i < kernel.length) {
            int dimensionId = dimensionIds[i];
            if (foreignIdToIndex.containsKey(dimensionId)) {
                kernel[i] = MathUtils.productOfRange(foreignDimensions, foreignIdToIndex.get(dimensionId) + 1, foreignDimensions.length);
            }
            ++i;
        }
        return kernel;
    }

    private static Map<Integer, Integer> computeIdToDimensionIndexMap(AbstractFactor factor) {
        HashMap<Integer, Integer> foreignIds = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < factor.getDimensionIDs().length) {
            foreignIds.put(factor.getDimensionIDs()[i], i);
            ++i;
        }
        return foreignIds;
    }
}

