/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import com.github.lbfgs4j.liblbfgs.Function;
import dr.evomodel.treedatalikelihood.discrete.MaximizerWrtParameter;
import dr.inference.operators.hmc.NumericalHessianFromGradient;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.util.Timer;
import dr.xml.Reportable;

public class LaplaceApproximation
implements Reportable {
    private final MaximizerWrtParameter maximizer;
    private final boolean diagonal;
    private final boolean estimateKL;
    private final boolean computeML;
    private double[] sdVector;
    private double[][] covarianceMatrix;
    private double[][] precisionMatrix;
    private double time = 0.0;
    private double KL = Double.NaN;
    private double ML = Double.NaN;

    public LaplaceApproximation(MaximizerWrtParameter maximizerWrtParameter, boolean bl, boolean bl2, boolean bl3) {
        this.maximizer = maximizerWrtParameter;
        this.diagonal = bl;
        this.estimateKL = bl2;
        this.computeML = bl3;
    }

    public void approximate() {
        int n;
        Timer timer = new Timer();
        double[] dArray = this.maximizer.getMinimumPoint(false);
        NumericalHessianFromGradient numericalHessianFromGradient = new NumericalHessianFromGradient(this.maximizer.getGradient());
        timer.start();
        this.precisionMatrix = numericalHessianFromGradient.getHessianLogDensity();
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                this.precisionMatrix[n][i] = -this.precisionMatrix[n][i];
            }
        }
        timer.stop();
        this.time += timer.toSeconds();
        this.covarianceMatrix = new Matrix(this.precisionMatrix).inverse().toComponents();
        if (this.diagonal) {
            this.sdVector = new double[dArray.length];
            for (n = 0; n < dArray.length; ++n) {
                this.sdVector[n] = Math.sqrt(this.covarianceMatrix[n][n]);
            }
        }
        MultivariateNormalDistribution multivariateNormalDistribution = new MultivariateNormalDistribution(dArray, this.precisionMatrix);
        Function function = this.maximizer.getFunction();
        if (this.estimateKL) {
            int n2 = 1000;
            this.KL = 0.0;
            for (int i = 0; i < n2; ++i) {
                double[] dArray2 = multivariateNormalDistribution.nextMultivariateNormal();
                double d = -function.valueAt(dArray2);
                this.KL += multivariateNormalDistribution.logPdf(dArray2) - d;
            }
            this.KL /= (double)n2;
        }
        if (this.computeML) {
            double d = multivariateNormalDistribution.getLogDet();
            this.ML = (double)dArray.length / 2.0 * Math.log(Math.PI * 2) + 0.5 * d - function.valueAt(dArray);
        }
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.maximizer.wasExecuted()) {
            stringBuilder.append("Not yet executed.");
        } else {
            stringBuilder.append("NB: Laplace approximation is taken in transformed space.\n");
            stringBuilder.append("Mean vector: ").append(new Vector(this.maximizer.getMinimumPoint(false))).append("\n");
            if (this.diagonal) {
                stringBuilder.append("Stdev vector: ").append(new Vector(this.sdVector)).append("\n");
            } else {
                stringBuilder.append("Covariance matrix: ").append(new Matrix(this.covarianceMatrix));
            }
            stringBuilder.append("Time to compute Hessian: ").append(this.time).append("s\n");
        }
        return stringBuilder.toString();
    }
}

