/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import dr.evomodel.branchmodel.lineagespecific.LineageSpecificBranchModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class LineageSpecificBranchModelParser
extends AbstractXMLObjectParser {
    public static final String MODELS = "models";
    public static final String CATEGORIES = "categories";

    @Override
    public String getParserName() {
        return "lineageSpecificBranchModel";
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
        FrequencyModel frequencyModel = (FrequencyModel)xMLObject.getChild(FrequencyModel.class);
        ArrayList<SubstitutionModel> arrayList = new ArrayList<SubstitutionModel>();
        XMLObject xMLObject2 = xMLObject.getChild(MODELS);
        for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
            SubstitutionModel substitutionModel = (SubstitutionModel)xMLObject2.getChild(i);
            arrayList.add(substitutionModel);
        }
        Parameter parameter = (Parameter)xMLObject.getElementFirstChild(CATEGORIES);
        return new LineageSpecificBranchModel(treeModel, frequencyModel, arrayList, parameter);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{new ElementRule(TreeModel.class, false), new ElementRule(FrequencyModel.class, false), new ElementRule(MODELS, new XMLSyntaxRule[]{new ElementRule(AbstractModel.class, 1, Integer.MAX_VALUE)}), new ElementRule(CATEGORIES, new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, 1)})};
    }

    @Override
    public String getParserDescription() {
        return "This element provides a branch model which has branches assigned to specific substitution models.These assignments can then be changed in course of MCMC.";
    }

    @Override
    public Class getReturnType() {
        return LineageSpecificBranchModel.class;
    }
}

