
/* Tests DTF creation and garbage collection of two tables for
different predicates. */

:- import abolish_table_pred/1, get_residual/2 from tables.

:- table tpred/1.
tpred(X):- p(X).

:- table upred/1.
upred(X):- p(X).

p(f(1)).
p(f(2)).
p(f(3)).
p(g(1)).
p(g(2)).
p(g(3)).

%------------------
:- dynamic tr/1.
:- index(tr/1,trie).

test :-
    abolish_all_tables,
    gc_tables(N0),
    test2,
    gc_tables(N1),
    N is N1-N0,
    (   N == 0
    ->  true
    ;   format(user_error,
               'Test abol_test3b left ~d tables.  Can happen.~n', [N])
    ),
    writeln(remaining(0)),
    get_residual(upred(X),_),writeln(first(X)).

test2 :-
    assert(tr(a)),
    assert(tr(b)),
    assert(tr(c)),fail.
test2 :-
    tpred(_X),fail.
test2 :-
    tpred(X),tr(Y),
    abolish_table_pred(tpred/1),
    writeln((X,Y)),fail.
test2 :-
    upred(_X),fail.
test2 :-
    upred(_X),tr(_Y),
    abolish_table_pred(upred/1),
    fail.
test2 :-
    upred(_),fail.
test2 :-
    get_residual(tpred(X),_),writeln(first(X)),fail.
test2 :-
    get_residual(upred(X),_),writeln(first(X)),fail.
test2.
