/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import org.dmg.pmml.PMML;
import org.jpmml.rexp.ConverterFactory;
import org.jpmml.rexp.PreProcessEncoder;
import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RecipeEncoder;
import org.jpmml.rexp.S4Object;

public abstract class Converter<R extends RExp> {
    private R object = null;

    public Converter(R object) {
        this.setObject(object);
    }

    public abstract PMML encodePMML(RExpEncoder var1);

    public PMML encodePMML() {
        RExpEncoder encoder = this.createEncoder();
        return this.encodePMML(encoder);
    }

    public RExpEncoder createEncoder() {
        RGenericVector recipe;
        RGenericVector preProcess;
        RExp model;
        R object = this.getObject();
        if (object instanceof S4Object) {
            model = (S4Object)object;
            preProcess = model.getGenericAttribute("preProcess", false);
            recipe = model.getGenericAttribute("recipe", false);
        } else if (object instanceof RGenericVector) {
            model = (RGenericVector)object;
            preProcess = ((RGenericVector)model).getGenericElement("preProcess", false);
            recipe = ((RGenericVector)model).getGenericElement("recipe", false);
        } else {
            preProcess = null;
            recipe = null;
        }
        if (preProcess != null && recipe != null) {
            throw new IllegalArgumentException();
        }
        RExpEncoder encoder = preProcess != null ? new PreProcessEncoder(preProcess) : (recipe != null ? new RecipeEncoder(recipe) : new RExpEncoder());
        return encoder;
    }

    public Boolean getOption(String name, Boolean defaultValue) {
        RBooleanVector option;
        RGenericVector options = this.getOptions();
        if (options != null && (option = options.getBooleanElement(name, false)) != null) {
            return (Boolean)option.asScalar();
        }
        return defaultValue;
    }

    public RGenericVector getOptions() {
        R object = this.getObject();
        if (object instanceof RGenericVector) {
            RGenericVector model = (RGenericVector)object;
            return model.getGenericElement("pmml_options", false);
        }
        return null;
    }

    public R getObject() {
        return this.object;
    }

    private void setObject(R object) {
        this.object = object;
    }

    public static <R extends RExp> Converter<R> newConverter(R rexp) {
        ConverterFactory converterFactory = ConverterFactory.newInstance();
        return converterFactory.newConverter(rexp);
    }
}

