/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.LinkedList;
import java.util.Random;
import moa.cluster.Clustering;
import moa.clusterers.Clusterer;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.StringUtils;
import moa.gui.AWTRenderer;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public abstract class AbstractClusterer
extends AbstractOptionHandler
implements Clusterer {
    protected InstancesHeader modelContext;
    protected double trainingWeightSeenByModel = 0.0;
    protected int randomSeed = 1;
    protected IntOption randomSeedOption;
    public FlagOption evaluateMicroClusteringOption;
    protected Random clustererRandom;
    protected Clustering clustering;

    @Override
    public String getPurposeString() {
        return "MOA Clusterer: " + this.getClass().getCanonicalName();
    }

    public AbstractClusterer() {
        if (this.isRandomizable()) {
            this.randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random behaviour of the Clusterer.", 1);
        }
        if (this.implementsMicroClusterer()) {
            this.evaluateMicroClusteringOption = new FlagOption("evaluateMicroClustering", 'M', "Evaluate the underlying microclustering instead of the macro clustering");
        }
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        if (this.randomSeedOption != null) {
            this.randomSeed = this.randomSeedOption.getValue();
        }
        if (!this.trainingHasStarted()) {
            this.resetLearning();
        }
        this.clustering = new Clustering();
    }

    @Override
    public void setModelContext(InstancesHeader ih) {
        if (ih != null && ih.classIndex() < 0) {
            throw new IllegalArgumentException("Context for a Clusterer must include a class to learn");
        }
        if (this.trainingHasStarted() && this.modelContext != null && (ih == null || !AbstractClusterer.contextIsCompatible(this.modelContext, ih))) {
            throw new IllegalArgumentException("New context is not compatible with existing model");
        }
        this.modelContext = ih;
    }

    @Override
    public InstancesHeader getModelContext() {
        return this.modelContext;
    }

    @Override
    public void setRandomSeed(int s) {
        this.randomSeed = s;
        if (this.randomSeedOption != null) {
            this.randomSeedOption.setValue(s);
        }
    }

    @Override
    public boolean trainingHasStarted() {
        return this.trainingWeightSeenByModel > 0.0;
    }

    @Override
    public double trainingWeightSeenByModel() {
        return this.trainingWeightSeenByModel;
    }

    @Override
    public void resetLearning() {
        this.trainingWeightSeenByModel = 0.0;
        if (this.isRandomizable()) {
            this.clustererRandom = new Random(this.randomSeed);
        }
        this.resetLearningImpl();
    }

    @Override
    public void trainOnInstance(Instance inst) {
        if (inst.weight() > 0.0) {
            this.trainingWeightSeenByModel += inst.weight();
            this.trainOnInstanceImpl(inst);
        }
    }

    @Override
    public Measurement[] getModelMeasurements() {
        Clusterer[] subModels;
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        measurementList.add(new Measurement("model training instances", this.trainingWeightSeenByModel()));
        measurementList.add(new Measurement("model serialized size (bytes)", this.measureByteSize()));
        Measurement[] modelMeasurements = this.getModelMeasurementsImpl();
        if (modelMeasurements != null) {
            for (Measurement measurement : modelMeasurements) {
                measurementList.add(measurement);
            }
        }
        if ((subModels = this.getSubClusterers()) != null && subModels.length > 0) {
            Measurement[] avgMeasurements;
            LinkedList<Measurement[]> subMeasurements = new LinkedList<Measurement[]>();
            for (Clusterer subModel : subModels) {
                if (subModel == null) continue;
                subMeasurements.add(subModel.getModelMeasurements());
            }
            for (Measurement measurement : avgMeasurements = Measurement.averageMeasurements((Measurement[][])subMeasurements.toArray((T[])new Measurement[subMeasurements.size()][]))) {
                measurementList.add(measurement);
            }
        }
        return measurementList.toArray(new Measurement[measurementList.size()]);
    }

    @Override
    public void getDescription(StringBuilder out, int indent) {
        StringUtils.appendIndented(out, indent, "Model type: ");
        out.append(this.getClass().getName());
        StringUtils.appendNewline(out);
        Measurement.getMeasurementsDescription(this.getModelMeasurements(), out, indent);
        StringUtils.appendNewlineIndented(out, indent, "Model description:");
        StringUtils.appendNewline(out);
        if (this.trainingHasStarted()) {
            this.getModelDescription(out, indent);
        } else {
            StringUtils.appendIndented(out, indent, "Model has not been trained.");
        }
    }

    @Override
    public Clusterer[] getSubClusterers() {
        return null;
    }

    @Override
    public Clusterer copy() {
        return (Clusterer)super.copy();
    }

    public String getClassNameString() {
        return InstancesHeader.getClassNameString(this.modelContext);
    }

    public String getClassLabelString(int classLabelIndex) {
        return InstancesHeader.getClassLabelString(this.modelContext, classLabelIndex);
    }

    public String getAttributeNameString(int attIndex) {
        return InstancesHeader.getAttributeNameString(this.modelContext, attIndex);
    }

    public String getNominalValueString(int attIndex, int valIndex) {
        return InstancesHeader.getNominalValueString(this.modelContext, attIndex, valIndex);
    }

    public static boolean contextIsCompatible(InstancesHeader originalContext, InstancesHeader newContext) {
        if (newContext.numClasses() < originalContext.numClasses()) {
            return false;
        }
        if (newContext.numAttributes() < originalContext.numAttributes()) {
            return false;
        }
        int oPos = 0;
        int nPos = 0;
        while (oPos < originalContext.numAttributes() && (oPos != originalContext.classIndex() || ++oPos < originalContext.numAttributes())) {
            if (nPos == newContext.classIndex()) {
                ++nPos;
            }
            if (originalContext.attribute(oPos).isNominal()) {
                if (!newContext.attribute(nPos).isNominal()) {
                    return false;
                }
                if (newContext.attribute(nPos).numValues() < originalContext.attribute(oPos).numValues()) {
                    return false;
                }
            } else {
                assert (originalContext.attribute(oPos).isNumeric());
                if (!newContext.attribute(nPos).isNumeric()) {
                    return false;
                }
            }
            ++oPos;
            ++nPos;
        }
        return true;
    }

    @Override
    public AWTRenderer getAWTRenderer() {
        return null;
    }

    public abstract void resetLearningImpl();

    public abstract void trainOnInstanceImpl(Instance var1);

    protected abstract Measurement[] getModelMeasurementsImpl();

    public abstract void getModelDescription(StringBuilder var1, int var2);

    protected static int modelAttIndexToInstanceAttIndex(int index, Instance inst) {
        return inst.classIndex() > index ? index : index + 1;
    }

    protected static int modelAttIndexToInstanceAttIndex(int index, Instances insts) {
        return insts.classIndex() > index ? index : index + 1;
    }

    @Override
    public boolean implementsMicroClusterer() {
        return false;
    }

    @Override
    public boolean keepClassLabel() {
        return false;
    }

    @Override
    public Clustering getMicroClusteringResult() {
        return null;
    }
}

