/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class SEEDChangeDetector
extends AbstractChangeDetector {
    protected SEED seed;
    public FloatOption deltaSEEDOption = new FloatOption("deltaSEED", 'd', "Delta value of SEED Detector", 0.05, 0.0, 1.0);
    public IntOption blockSizeSEEDOption = new IntOption("blockSizeSEED", 'b', "BlockSize value of SEED Detector", 32, 32, 256);
    public FloatOption epsilonPrimeSEEDOption = new FloatOption("epsilonPrimeSEED", 'e', "EpsilonPrime value of SEED Detector", 0.01, 0.0025, 0.01);
    public FloatOption alphaSEEDOption = new FloatOption("alphaSEED", 'a', "Alpha value of SEED Detector", 0.8, 0.2, 0.8);
    public IntOption compressTermSEEDOption = new IntOption("compressTermSEED", 'c', "CompressTerm value of SEED Detector", 75, 50, 100);

    @Override
    public void input(double inputValue) {
        if (this.seed == null) {
            this.resetLearning();
        }
        this.isChangeDetected = this.seed.setInput(inputValue);
        this.isWarningZone = false;
        this.delay = 0.0;
        this.estimation = 0.0;
    }

    @Override
    public void resetLearning() {
        this.seed = new SEED(this.deltaSEEDOption.getValue(), this.blockSizeSEEDOption.getValue(), this.epsilonPrimeSEEDOption.getValue(), this.alphaSEEDOption.getValue(), this.compressTermSEEDOption.getValue());
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    public class SEEDWindow {
        private SEEDBlock head;
        private SEEDBlock tail;
        private int blockSize;
        private int width;
        private double total;
        private double variance;
        private int blockCount;
        private int DECAY_MODE = 1;
        private final int LINEAR_DECAY = 1;
        private final int EXPONENTIAL_DECAY = 2;
        private int COMPRESSION_MODE = 1;
        private final int FIXED_TERM = 1;
        private int decayCompressionCount = 0;
        private int linearFixedTermSize = 50;
        private double epsilonPrime = 0.0;
        private double alpha = 0.0;

        public SEEDWindow(int blockSize) {
            this.clear();
            this.blockSize = blockSize;
            this.addBlockToHead(new SEEDBlock(blockSize));
        }

        public SEEDWindow(int blockSize, int decayMode, int compressionMode, double epsilonPrime, double alpha, int compressionTerm) {
            this.clear();
            this.blockSize = blockSize;
            this.DECAY_MODE = decayMode;
            this.COMPRESSION_MODE = compressionMode;
            this.epsilonPrime = epsilonPrime;
            this.alpha = alpha;
            this.setCompressionTerm(compressionTerm);
            this.addBlockToHead(new SEEDBlock(blockSize));
        }

        public void clear() {
            this.head = null;
            this.tail = null;
            this.width = 0;
            this.blockCount = 0;
            this.total = 0.0;
            this.variance = 0.0;
        }

        public void addTransaction(double value) {
            if (this.tail.isFull()) {
                if (this.COMPRESSION_MODE == 1 && this.tail.getPrevious() != null && this.decayCompressionCount > this.linearFixedTermSize) {
                    this.decayCompressionCount = 0;
                    SEEDBlock cursor = this.tail;
                    double epsilon = 0.0;
                    int i = 0;
                    while (cursor != null && cursor.getPrevious() != null) {
                        double n0 = cursor.getItemCount();
                        double n1 = cursor.getPrevious().getItemCount();
                        double u0 = cursor.getTotal();
                        double u1 = cursor.getPrevious().getTotal();
                        double diff = Math.abs(u1 / n1 - u0 / n0);
                        if (this.DECAY_MODE == 1) {
                            epsilon += this.epsilonPrime * this.alpha;
                        } else if (this.DECAY_MODE == 2) {
                            epsilon = this.epsilonPrime * Math.pow(1.0 + this.alpha, i);
                        }
                        if (diff < epsilon) {
                            this.compressBlock(cursor);
                        }
                        cursor = cursor.getPrevious();
                        ++i;
                    }
                }
                this.addBlockToTail(new SEEDBlock(this.blockSize));
                ++this.decayCompressionCount;
            }
            this.tail.add(value);
            this.total += value;
            ++this.width;
            if (this.width >= 2) {
                double incVariance = (double)(this.width - 1) * (value - this.total / (double)(this.width - 1)) * (value - this.total / (double)(this.width - 1)) / (double)this.width;
                this.variance += incVariance;
                this.tail.setVariance(this.tail.getVariance() + incVariance);
            }
        }

        public void compressBlock(SEEDBlock cursor) {
            cursor.getPrevious().setTotal(cursor.getTotal() + cursor.getPrevious().getTotal());
            cursor.getPrevious().setItemCount(cursor.getItemCount() + cursor.getPrevious().getItemCount());
            cursor.getPrevious().setVariance(cursor.getVariance() + cursor.getPrevious().getVariance());
            cursor.getPrevious().setBlockSize(cursor.getBlockSize() + cursor.getPrevious().getBlockSize());
            if (cursor.getNext() != null) {
                cursor.getPrevious().setNext(cursor.getNext());
                cursor.getNext().setPrevious(cursor.getPrevious());
            } else {
                cursor.getPrevious().setNext(null);
                this.tail = cursor.getPrevious();
            }
            --this.blockCount;
        }

        public boolean checkHomogeneity(SEEDBlock block) {
            double epsilonPrime;
            double diff = Math.abs(block.getMean() - block.getPrevious().getMean());
            return diff < (epsilonPrime = this.getADWINBound(block.getItemCount(), block.getPrevious().getItemCount()));
        }

        private double getADWINBound(double n0, double n1) {
            double n = n0 + n1;
            double dd = Math.log(2.0 * Math.log(n) / 0.99);
            double v = this.variance / (double)this.width;
            double m = 1.0 / n0 + 1.0 / n1;
            double epsilon = Math.sqrt(2.0 * m * v * dd) + 0.6666666666666666 * dd * m;
            return epsilon;
        }

        public void addBlockToHead(SEEDBlock block) {
            if (this.head == null) {
                this.head = block;
                this.tail = block;
            } else {
                block.setNext(this.head);
                this.head.setPrevious(block);
                this.head = block;
            }
            ++this.blockCount;
        }

        public void removeBlock(SEEDBlock block) {
            this.width -= block.getItemCount();
            this.total -= block.getTotal();
            this.variance -= block.getVariance();
            --this.blockCount;
            if (block.getPrevious() != null && block.getNext() != null) {
                block.getPrevious().setNext(block.getNext());
                block.getNext().setPrevious(block.getPrevious());
                block.setNext(null);
                block.setPrevious(null);
            } else if (block.getPrevious() == null && block.getNext() != null) {
                block.getNext().setPrevious(null);
                this.head = block.getNext();
                block.setNext(null);
            } else if (block.getPrevious() != null && block.getNext() == null) {
                block.getPrevious().setNext(null);
                this.tail = block.getPrevious();
                block.setPrevious(null);
            } else if (block.getPrevious() == null && block.getNext() == null) {
                this.head = null;
                this.tail = null;
            }
        }

        public void addBlockToTail(SEEDBlock block) {
            if (this.tail == null) {
                this.tail = block;
                this.head = block;
            } else {
                block.setPrevious(this.tail);
                this.tail.setNext(block);
                this.tail = block;
            }
            ++this.blockCount;
        }

        public int getBlockCount() {
            return this.blockCount;
        }

        public void setBlockCount(int value) {
            this.blockCount = value;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int value) {
            this.width = value;
        }

        public void setHead(SEEDBlock head) {
            this.head = head;
        }

        public void setTail(SEEDBlock tail) {
            this.tail = tail;
        }

        public SEEDBlock getHead() {
            return this.head;
        }

        public SEEDBlock getTail() {
            return this.tail;
        }

        public double getTotal() {
            return this.total;
        }

        public void setTotal(double value) {
            this.total = value;
        }

        public double getVariance() {
            return this.variance;
        }

        public void setVariance(double value) {
            this.variance = value;
        }

        public void setBlockSize(int value) {
            this.blockSize = value > 32 ? value : 32;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public double getEpsilonPrime() {
            return this.epsilonPrime;
        }

        public void setEpsilonPrime(double epsilonPrime) {
            this.epsilonPrime = epsilonPrime;
        }

        public void setAlpha(double alpha) {
            this.alpha = alpha;
        }

        public void setCompressionTerm(int value) {
            this.linearFixedTermSize = value;
        }
    }

    public class SEEDBlock {
        private SEEDBlock next;
        private SEEDBlock previous;
        private int blockSize;
        private double total;
        private double variance;
        private int itemCount;

        public SEEDBlock(int blockSize) {
            this.next = null;
            this.previous = null;
            this.blockSize = blockSize;
            this.total = 0.0;
            this.variance = 0.0;
            this.itemCount = 0;
        }

        public SEEDBlock(SEEDBlock block) {
            this.next = block.getNext();
            this.previous = block.getPrevious();
            this.blockSize = block.blockSize;
            this.total = block.total;
            this.variance = block.variance;
            this.itemCount = block.itemCount;
        }

        public void setNext(SEEDBlock next) {
            this.next = next;
        }

        public SEEDBlock getNext() {
            return this.next;
        }

        public void setPrevious(SEEDBlock previous) {
            this.previous = previous;
        }

        public SEEDBlock getPrevious() {
            return this.previous;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public void setBlockSize(int blockSize) {
            this.blockSize = blockSize;
        }

        public void add(double value) {
            ++this.itemCount;
            this.total += value;
        }

        public boolean isFull() {
            return this.itemCount == this.blockSize;
        }

        public double getMean() {
            return this.total / (double)this.itemCount;
        }

        public void setTotal(double value) {
            this.total = value;
        }

        public double getTotal() {
            return this.total;
        }

        public void setItemCount(int value) {
            this.itemCount = value;
        }

        public int getItemCount() {
            return this.itemCount;
        }

        public void setVariance(double value) {
            this.variance = value;
        }

        public double getVariance() {
            return this.variance;
        }
    }

    public class SEED {
        public SEEDWindow window;
        private double DELTA;
        private int blockSize;
        private int elementCount;

        public SEED(double delta, int blockSize, double epsilonPrime, double alpha, int term) {
            this.DELTA = delta;
            this.blockSize = blockSize;
            this.window = new SEEDWindow(blockSize, 1, 1, epsilonPrime, alpha, term);
        }

        public boolean setInput(double inputValue) {
            this.addElement(inputValue);
            if (this.elementCount % this.blockSize == 0 && this.window.getBlockCount() >= 2) {
                boolean blnReduceWidth = true;
                while (blnReduceWidth) {
                    blnReduceWidth = false;
                    int n1 = 0;
                    int n0 = this.window.getWidth();
                    double u1 = 0.0;
                    double u0 = this.window.getTotal();
                    SEEDBlock cursor = this.window.getTail();
                    while (cursor.getPrevious() != null) {
                        n0 -= cursor.getItemCount();
                        n1 += cursor.getItemCount();
                        u0 -= cursor.getTotal();
                        double diff = Math.abs((u1 += cursor.getTotal()) / (double)n1 - u0 / (double)n0);
                        if (diff > this.getADWINBound(n0, n1)) {
                            blnReduceWidth = true;
                            this.window.setHead(cursor);
                            while (cursor.getPrevious() != null) {
                                cursor = cursor.getPrevious();
                                this.window.setWidth(this.window.getWidth() - cursor.getItemCount());
                                this.window.setTotal(this.window.getTotal() - cursor.getTotal());
                                this.window.setVariance(this.window.getVariance() - cursor.getVariance());
                                this.window.setBlockCount(this.window.getBlockCount() - 1);
                            }
                            this.window.getHead().setPrevious(null);
                            return true;
                        }
                        cursor = cursor.getPrevious();
                    }
                }
            }
            return false;
        }

        private double getADWINBound(double n0, double n1) {
            double n = n0 + n1;
            double dd = Math.log(2.0 * Math.log(n) / this.DELTA);
            double v = this.window.getVariance() / (double)this.window.getWidth();
            double m = 1.0 / n0 + 1.0 / n1;
            double epsilon = Math.sqrt(2.0 * m * v * dd) + 0.6666666666666666 * dd * m;
            return epsilon;
        }

        public void addElement(double value) {
            this.window.addTransaction(value);
            ++this.elementCount;
        }
    }
}

