/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.convert;

import java.io.IOException;
import opennlp.tools.postag.POSSample;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSToTokenSampleStream
extends FilterObjectStream<POSSample, TokenSample> {
    private final Detokenizer detokenizer;

    public POSToTokenSampleStream(Detokenizer detokenizer, ObjectStream<POSSample> samples) {
        super(samples);
        if (detokenizer == null) {
            throw new IllegalArgumentException("detokenizer must not be null!");
        }
        this.detokenizer = detokenizer;
    }

    @Override
    public TokenSample read() throws IOException {
        POSSample posSample = (POSSample)this.samples.read();
        TokenSample tokenSample = null;
        if (posSample != null) {
            tokenSample = new TokenSample(this.detokenizer, posSample.getSentence());
        }
        return tokenSample;
    }
}

