/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Metric;
import cc.mallet.types.SparseVector;

public class InfiniteDistance
implements Metric {
    @Override
    public double distance(SparseVector a, SparseVector b) {
        double diff;
        double maxDiff = 0.0;
        if (a == null || b == null) {
            throw new IllegalArgumentException("Distance from a null vector is undefined.");
        }
        int leftLength = a.numLocations();
        int rightLength = b.numLocations();
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < leftLength && rightIndex < rightLength) {
            int rightFeature;
            int leftFeature = a.indexAtLocation(leftIndex);
            if (leftFeature < (rightFeature = b.indexAtLocation(rightIndex))) {
                diff = Math.abs(a.valueAtLocation(leftIndex));
                ++leftIndex;
            } else if (leftFeature == rightFeature) {
                diff = Math.abs(a.valueAtLocation(leftIndex) - b.valueAtLocation(rightIndex));
                ++leftIndex;
                ++rightIndex;
            } else {
                diff = Math.abs(b.valueAtLocation(rightIndex));
                ++rightIndex;
            }
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
        }
        while (leftIndex < leftLength) {
            diff = Math.abs(a.valueAtLocation(leftIndex));
            if (diff > maxDiff) {
                maxDiff = diff;
            }
            ++leftIndex;
        }
        while (rightIndex < rightLength) {
            diff = Math.abs(b.valueAtLocation(rightIndex));
            if (diff > maxDiff) {
                maxDiff = diff;
            }
            ++rightIndex;
        }
        return maxDiff;
    }
}

