/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.GENN;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class GENNGenerator
extends PrototypeGenerator {
    protected int k = 4;

    public GENNGenerator(PrototypeSet tr, int k) {
        super(tr);
        this.algorithmName = "GENN";
        this.k = k;
    }

    public GENNGenerator(PrototypeSet tr, Parameters param) {
        super(tr, param);
        this.algorithmName = "GENN";
        this.k = param.getNextAsInt();
    }

    protected boolean majorityOfSameClass(Prototype current, PrototypeSet protSet) {
        double currentLabel = current.label();
        int protSet_size = protSet.size();
        int count = 0;
        for (Prototype p : protSet) {
            if (currentLabel != p.label()) continue;
            ++count;
        }
        return count > protSet_size / 2;
    }

    @Override
    public PrototypeSet reduceSet() {
        int _size = this.trainingDataSet.size();
        PrototypeSet result = new PrototypeSet(_size);
        result.add(this.trainingDataSet);
        KNN.setK(this.k);
        int numberOfGroups = _size / this.k;
        int index = RandomGenerator.Randint(0, _size);
        for (int i = 0; i < numberOfGroups; ++i) {
            PrototypeSet neighbors;
            Prototype current = (Prototype)result.get(index);
            if (this.majorityOfSameClass(current, neighbors = KNN.knn(current, result))) {
                double maxFreqClass = neighbors.mostFrequentClass();
                for (Prototype p : neighbors) {
                    p.setLabel(maxFreqClass);
                }
                current.setLabel(maxFreqClass);
            } else {
                result.remove(index);
                for (Prototype p : neighbors) {
                    result.remove(p);
                }
            }
            index = RandomGenerator.Randint(0, result.size() - 1);
        }
        return result;
    }

    public static void main(String[] args) {
        Parameters.setUse("GENN", "<seed> <k (size of neighborhood in KNN)>");
        Parameters.assertBasicArgs(args);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        GENNGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "size of the neighborhood", 1.0, 10.0);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        GENNGenerator generator = new GENNGenerator(training, k);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy1NN(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

