/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;

public class SJDBCBridge {
    private static final int SPLUS_32BIT_NA = 2146435073;
    private static final long SPLUS_64BIT_NA = 0x7FFFFFFF7FFFFFFFL;
    private static final int R_INTEGER_NA = Integer.MIN_VALUE;
    private static final double R_NUMERIC_NA = Double.longBitsToDouble(9218868437227407266L);
    private static final double R_NUMERIC_NAN = Double.NaN;
    private static final Hashtable<String, SJDBCDataFrame> g_dfTable = new Hashtable();
    private static final Hashtable<String, PreparedStatement> g_insertStatementHash = new Hashtable();
    private static Connection g_conn;
    private static String[] g_connInfo;
    private static URLClassLoader g_ucl;
    private static ArrayList<String> g_regDrivers;

    private static boolean is64Bit() {
        return System.getProperty("os.arch").indexOf("64") != -1 || System.getProperty("sun.arch.data.model").indexOf("64") != -1;
    }

    public static void sjdbcImportData(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        connection = SJDBCBridge.establishConnection(string, string2, string3, string4);
        statement = connection.createStatement();
        resultSet = statement.executeQuery(string5);
        SJDBCResultSetUtilities.register(string6, resultSet);
    }

    public static void sjdbcTypeInfo(String string, String string2, String string3, String string4, String string5) throws Exception {
        Connection connection = null;
        ResultSet resultSet = null;
        connection = SJDBCBridge.establishConnection(string, string2, string3, string4);
        resultSet = connection.getMetaData().getTypeInfo();
        SJDBCResultSetUtilities.register(string5, resultSet);
    }

    public static void sjdbcCloseConnection() throws SQLException {
        if (g_conn != null && !g_conn.isClosed()) {
            g_conn.close();
        }
        g_connInfo = new String[]{"", "", "", "", ""};
    }

    public static void sjdbcAddDrivers(String[] stringArray) throws Exception {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            uRLArray[i] = new File(stringArray[i]).toURI().toURL();
        }
        g_ucl = g_ucl == null ? new URLClassLoader(uRLArray) : new URLClassLoader(uRLArray, (ClassLoader)g_ucl);
    }

    private static Connection establishConnection(String string, String string2, String string3, String string4) throws Exception {
        if (g_conn != null && !g_conn.isClosed() && string.equals(g_connInfo[0]) && string2.equals(g_connInfo[1]) && string3.equals(g_connInfo[2]) && string4.equals(g_connInfo[3])) {
            return g_conn;
        }
        SJDBCBridge.sjdbcCloseConnection();
        if (!g_regDrivers.contains(string)) {
            Driver driver = (Driver)g_ucl.loadClass(string).newInstance();
            DriverManager.registerDriver(new SJDBCDriverShim(driver));
            g_regDrivers.add(string);
        }
        if (string3.length() == 0) {
            g_conn = DriverManager.getConnection(string2);
            g_connInfo = new String[]{string, string2, "", "", ""};
        } else {
            g_conn = DriverManager.getConnection(string2, string3, string4);
            g_connInfo = new String[]{string, string2, string3, string4, ""};
        }
        return g_conn;
    }

    public static int sjdbcExecute(String string, String string2, String string3, String string4, String string5) throws Exception {
        Connection connection = null;
        Statement statement = null;
        connection = SJDBCBridge.establishConnection(string, string2, string3, string4);
        statement = connection.createStatement();
        statement.executeUpdate(string5);
        return statement.getUpdateCount();
    }

    public static void sjdbcExportStart(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3) throws Exception {
        Object object;
        String string7;
        Connection connection = null;
        Statement statement = null;
        String string8 = "";
        Hashtable<Integer, String[]> hashtable = new Hashtable<Integer, String[]>();
        if (!g_dfTable.containsKey(string)) {
            throw new Exception("Data id does not exist.");
        }
        SJDBCDataFrame sJDBCDataFrame = g_dfTable.get(string);
        connection = SJDBCBridge.establishConnection(string2, string3, string4, string5);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        SJDBCBridge.g_connInfo[4] = Boolean.toString(databaseMetaData.supportsBatchUpdates());
        String string9 = databaseMetaData.getIdentifierQuoteString();
        String string10 = "'";
        String string11 = "'";
        ResultSet resultSet = databaseMetaData.getTypeInfo();
        while (resultSet.next()) {
            int n = resultSet.getInt("DATA_TYPE");
            string7 = resultSet.getString("PRECISION") == null ? "0" : resultSet.getString("PRECISION");
            object = resultSet.getString("TYPE_NAME");
            switch (n) {
                case 12: {
                    string10 = resultSet.getString("LITERAL_PREFIX");
                    string11 = resultSet.getString("LITERAL_SUFFIX");
                }
            }
            if (hashtable.containsKey(n) && Integer.parseInt(((String[])hashtable.get(n))[1]) >= Integer.parseInt(string7)) continue;
            hashtable.put(n, new String[]{object, string7});
        }
        IdentifierCase identifierCase = IdentifierCase.MIXED;
        if (!bl2) {
            if (databaseMetaData.storesLowerCaseIdentifiers()) {
                identifierCase = IdentifierCase.LOWER;
            } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
                identifierCase = IdentifierCase.UPPER;
            }
        }
        if (bl3) {
            connection.setAutoCommit(false);
        }
        try {
            if (!bl) {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("DROP TABLE " + string6);
                }
                catch (SQLException sQLException) {
                    connection.rollback();
                }
                string8 = SJDBCBridge.createSQLCreateTable(sJDBCDataFrame.getColNames(), sJDBCDataFrame.getColTypes(), hashtable, string6, string9, identifierCase);
                statement.executeUpdate(string8);
                statement.close();
            }
            string7 = SJDBCBridge.createSQLColNames(sJDBCDataFrame.getColNames(), string9, identifierCase);
            string8 = "INSERT INTO " + string6 + " " + string7 + " VALUES " + SJDBCBridge.createSQLRowTemplate(sJDBCDataFrame.columns());
            object = connection.prepareStatement(string8);
            g_insertStatementHash.put(string, (PreparedStatement)object);
        }
        catch (Exception exception) {
            try {
                connection.rollback();
                connection.setAutoCommit(true);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                SJDBCBridge.sjdbcCloseConnection();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw exception;
        }
    }

    public static int sjdbcExportData(String string, boolean bl) throws Exception {
        return SJDBCBridge.sjdbcExportData(string, bl, 1000);
    }

    public static int sjdbcExportData(String string, boolean bl, int n) throws Exception {
        if (!g_dfTable.containsKey(string)) {
            throw new Exception("Data id does not exist.");
        }
        SJDBCDataFrame sJDBCDataFrame = g_dfTable.get(string);
        boolean bl2 = SJDBCBridge.is64Bit();
        if (g_conn == null || g_conn.isClosed()) {
            throw new Exception("Connection closed");
        }
        Connection connection = g_conn;
        boolean bl3 = n > 0 && Boolean.valueOf(g_connInfo[4]) != false;
        Integer[] integerArray = sJDBCDataFrame.getColTypes();
        try {
            PreparedStatement preparedStatement = g_insertStatementHash.get(string);
            for (int i = 0; i < sJDBCDataFrame.length(); ++i) {
                block13: for (int j = 0; j < sJDBCDataFrame.columns(); ++j) {
                    switch (integerArray[j]) {
                        case 4: {
                            int n2 = sJDBCDataFrame.getIntegerData(j, i);
                            if (n2 == Integer.MIN_VALUE) {
                                preparedStatement.setNull(j + 1, 4);
                                continue block13;
                            }
                            preparedStatement.setInt(j + 1, n2);
                            continue block13;
                        }
                        case 8: {
                            double d = sJDBCDataFrame.getDoubleData(j, i);
                            if (Double.isNaN(d)) {
                                preparedStatement.setNull(j + 1, 8);
                                continue block13;
                            }
                            preparedStatement.setDouble(j + 1, d);
                            continue block13;
                        }
                        case 12: {
                            String string2 = sJDBCDataFrame.getStringData(j, i);
                            if (string2 == null) {
                                preparedStatement.setNull(j + 1, 12);
                                continue block13;
                            }
                            preparedStatement.setString(j + 1, string2);
                            continue block13;
                        }
                        case 93: {
                            Timestamp timestamp = sJDBCDataFrame.getDateData(j, i);
                            if (timestamp == null) {
                                preparedStatement.setNull(j + 1, 93);
                                continue block13;
                            }
                            preparedStatement.setTimestamp(j + 1, timestamp);
                        }
                    }
                }
                if (bl3) {
                    preparedStatement.addBatch();
                    if ((i + 1) % n != 0) continue;
                    preparedStatement.executeBatch();
                    continue;
                }
                preparedStatement.executeUpdate();
            }
            if (bl3 && sJDBCDataFrame.length() % n != 0) {
                preparedStatement.executeBatch();
            }
            if (bl) {
                connection.commit();
                connection.setAutoCommit(true);
            }
        }
        catch (Exception exception) {
            try {
                connection.rollback();
                connection.setAutoCommit(true);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                SJDBCBridge.sjdbcCloseConnection();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw exception;
        }
        return sJDBCDataFrame.length();
    }

    public static void sjdbcCreateData(String string) throws Exception {
        g_dfTable.put(string, new SJDBCDataFrame());
    }

    public static void sjdbcClearData(String string) throws Exception {
        g_dfTable.remove(string);
        g_insertStatementHash.remove(string);
    }

    public static void sjdbcAddIntegerColumn(String string, String string2, int[] nArray) throws Exception {
        if (!g_dfTable.containsKey(string)) {
            throw new Exception("Data id does not exist.");
        }
        SJDBCDataFrame sJDBCDataFrame = g_dfTable.get(string);
        sJDBCDataFrame.addIntegerColumn(string2, nArray);
    }

    public static void sjdbcAddLongColumn(String string, String string2, long[] lArray) throws Exception {
        if (!g_dfTable.containsKey(string)) {
            throw new Exception("Data id does not exist.");
        }
        SJDBCDataFrame sJDBCDataFrame = g_dfTable.get(string);
        sJDBCDataFrame.addLongColumn(string2, lArray);
    }

    public static void sjdbcAddDateColumn(String string, String string2, String[] stringArray) throws Exception {
        if (!g_dfTable.containsKey(string)) {
            throw new Exception("Data id does not exist.");
        }
        SJDBCDataFrame sJDBCDataFrame = g_dfTable.get(string);
        sJDBCDataFrame.addDateColumn(string2, stringArray);
    }

    public static void sjdbcAddDoubleColumn(String string, String string2, double[] dArray) throws Exception {
        if (!g_dfTable.containsKey(string)) {
            throw new Exception("Data id does not exist.");
        }
        SJDBCDataFrame sJDBCDataFrame = g_dfTable.get(string);
        sJDBCDataFrame.addDoubleColumn(string2, dArray);
    }

    public static void sjdbcAddStringColumn(String string, String string2, String[] stringArray) throws Exception {
        if (!g_dfTable.containsKey(string)) {
            throw new Exception("Data id does not exist.");
        }
        SJDBCDataFrame sJDBCDataFrame = g_dfTable.get(string);
        sJDBCDataFrame.addStringColumn(string2, stringArray);
    }

    private static String createSQLColNames(String[] stringArray, String string, IdentifierCase identifierCase) {
        String string2 = "( ";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            if (i > 0) {
                string2 = string2 + ", ";
            }
            switch (identifierCase) {
                case UPPER: {
                    string3 = stringArray[i].toUpperCase();
                    break;
                }
                case LOWER: {
                    string3 = stringArray[i].toLowerCase();
                    break;
                }
                default: {
                    string3 = stringArray[i];
                }
            }
            string2 = string2 + string + string3 + string;
            string2 = string2 + " ";
        }
        string2 = string2 + ")";
        return string2;
    }

    private static String createSQLCreateTable(String[] stringArray, Integer[] integerArray, Hashtable<Integer, String[]> hashtable, String string, String string2, IdentifierCase identifierCase) throws SQLException {
        String string3 = "CREATE TABLE " + string + " ( ";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            if (i > 0) {
                string3 = string3 + ", ";
            }
            switch (identifierCase) {
                case UPPER: {
                    string4 = stringArray[i].toUpperCase();
                    break;
                }
                case LOWER: {
                    string4 = stringArray[i].toLowerCase();
                    break;
                }
                default: {
                    string4 = stringArray[i];
                }
            }
            String string5 = "";
            switch (integerArray[i]) {
                case 4: {
                    if (!hashtable.containsKey(4)) break;
                    string5 = hashtable.get(4)[0];
                    break;
                }
                case 8: {
                    if (hashtable.containsKey(8)) {
                        string5 = hashtable.get(8)[0];
                        break;
                    }
                    if (!hashtable.containsKey(6)) break;
                    string5 = hashtable.get(6)[0];
                    break;
                }
                case 12: {
                    string5 = "VARCHAR(255)";
                    break;
                }
                case 93: {
                    if (!hashtable.containsKey(93)) break;
                    string5 = hashtable.get(93)[0];
                }
            }
            if (string5.length() == 0) {
                throw new SQLException("Could not determine column type for '" + stringArray[i] + "' with SQL Type '" + integerArray[i] + "'.");
            }
            string3 = string3 + string2 + string4 + string2 + " " + string5;
        }
        string3 = string3 + " )";
        return string3;
    }

    private static String createSQLRowTemplate(int n) {
        String string = "( ";
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                string = string + ", ";
            }
            string = string + "?";
        }
        string = string + ")";
        return string;
    }

    static {
        g_connInfo = new String[]{"", "", "", "", ""};
        g_ucl = null;
        g_regDrivers = new ArrayList();
    }

    public static enum IdentifierCase {
        UPPER,
        LOWER,
        MIXED;

    }
}

