/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.jmx;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.apache.zookeeper.jmx.ZKMBeanInfo;

public class MBeanRegistry {
    private static final Logger LOG = Logger.getLogger(MBeanRegistry.class);
    private static MBeanRegistry instance = new MBeanRegistry();
    private Map<ZKMBeanInfo, String> mapBean2Path = new ConcurrentHashMap<ZKMBeanInfo, String>();
    private Map<String, ZKMBeanInfo> mapName2Bean = new ConcurrentHashMap<String, ZKMBeanInfo>();

    public static MBeanRegistry getInstance() {
        return instance;
    }

    public void register(ZKMBeanInfo bean, ZKMBeanInfo parent) throws JMException {
        assert (bean != null);
        String path = null;
        if (parent != null) {
            path = this.mapBean2Path.get(parent);
            assert (path != null);
        }
        path = this.makeFullPath(path, parent);
        this.mapBean2Path.put(bean, path);
        this.mapName2Bean.put(bean.getName(), bean);
        if (bean.isHidden()) {
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName oname = this.makeObjectName(path, bean);
        try {
            mbs.registerMBean(bean, oname);
        }
        catch (JMException e) {
            LOG.warn("Failed to register MBean " + bean.getName());
            throw e;
        }
    }

    private void unregister(String path, ZKMBeanInfo bean) throws JMException {
        if (path == null) {
            return;
        }
        if (!bean.isHidden()) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(this.makeObjectName(path, bean));
            }
            catch (JMException e) {
                LOG.warn("Failed to unregister MBean " + bean.getName());
                throw e;
            }
        }
    }

    public void unregister(ZKMBeanInfo bean) {
        if (bean == null) {
            return;
        }
        String path = this.mapBean2Path.get(bean);
        try {
            this.unregister(path, bean);
        }
        catch (JMException e) {
            LOG.warn("Error during unregister", e);
        }
        this.mapBean2Path.remove(bean);
        this.mapName2Bean.remove(bean.getName());
    }

    public void unregisterAll() {
        for (Map.Entry<ZKMBeanInfo, String> e : this.mapBean2Path.entrySet()) {
            try {
                this.unregister(e.getValue(), e.getKey());
            }
            catch (JMException e1) {
                LOG.warn("Error during unregister", e1);
            }
        }
        this.mapBean2Path.clear();
        this.mapName2Bean.clear();
    }

    public String makeFullPath(String prefix, String ... name) {
        StringBuilder sb = new StringBuilder(prefix == null ? "/" : (prefix.equals("/") ? prefix : prefix + "/"));
        boolean first = true;
        for (String s : name) {
            if (s == null) continue;
            if (!first) {
                sb.append("/");
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    protected String makeFullPath(String prefix, ZKMBeanInfo bean) {
        return this.makeFullPath(prefix, bean == null ? null : bean.getName());
    }

    private int tokenize(StringBuilder sb, String path, int index2) {
        String[] tokens;
        for (String s : tokens = path.split("/")) {
            if (s.length() == 0) continue;
            sb.append("name").append(index2++).append("=").append(s).append(",");
        }
        return index2;
    }

    protected ObjectName makeObjectName(String path, ZKMBeanInfo bean) throws MalformedObjectNameException {
        if (path == null) {
            return null;
        }
        StringBuilder beanName = new StringBuilder("org.apache.ZooKeeperService:");
        int counter = 0;
        counter = this.tokenize(beanName, path, counter);
        this.tokenize(beanName, bean.getName(), counter);
        beanName.deleteCharAt(beanName.length() - 1);
        try {
            return new ObjectName(beanName.toString());
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Invalid name \"" + beanName.toString() + "\" for class " + bean.getClass().toString());
            throw e;
        }
    }
}

