/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smarts;

import java.util.Arrays;
import java.util.Locale;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public final class SmartsFragmentExtractor {
    public static final int MODE_JCOMPOUNDMAPPER = 1;
    public static final int MODE_EXACT = 2;
    private final IAtomContainer mol;
    private final int[][] atomAdj;
    private final int[][] bondAdj;
    private final int[] deg;
    private final String[] aexpr;
    private final String[] bexpr;
    private final int[] avisit;
    private final int[] rbnds;
    private final int[] rnums;
    private int numVisit;
    private int mode = 2;

    public SmartsFragmentExtractor(IAtomContainer mol) {
        this.mol = mol;
        int numAtoms = mol.getAtomCount();
        int numBonds = mol.getBondCount();
        this.deg = new int[numAtoms];
        this.atomAdj = new int[numAtoms][4];
        this.bondAdj = new int[numAtoms][4];
        this.aexpr = new String[numAtoms];
        this.bexpr = new String[numBonds];
        this.avisit = new int[numAtoms];
        this.rbnds = new int[numBonds];
        this.rnums = new int[100];
        int bondIdx = 0;
        while (bondIdx < numBonds) {
            IBond bond = mol.getBond(bondIdx);
            IAtom beg = bond.getBegin();
            IAtom end = bond.getEnd();
            int begIdx = mol.indexOf(beg);
            int endIdx = mol.indexOf(end);
            this.bexpr[bondIdx] = this.encodeBondExpr(bondIdx, begIdx, endIdx);
            if (this.deg[begIdx] == this.atomAdj[begIdx].length) {
                this.atomAdj[begIdx] = Arrays.copyOf(this.atomAdj[begIdx], this.deg[begIdx] + 2);
                this.bondAdj[begIdx] = Arrays.copyOf(this.bondAdj[begIdx], this.deg[begIdx] + 2);
            }
            if (this.deg[endIdx] == this.atomAdj[endIdx].length) {
                this.atomAdj[endIdx] = Arrays.copyOf(this.atomAdj[endIdx], this.deg[endIdx] + 2);
                this.bondAdj[endIdx] = Arrays.copyOf(this.bondAdj[endIdx], this.deg[endIdx] + 2);
            }
            this.atomAdj[begIdx][this.deg[begIdx]] = endIdx;
            this.bondAdj[begIdx][this.deg[begIdx]] = bondIdx;
            this.atomAdj[endIdx][this.deg[endIdx]] = begIdx;
            this.bondAdj[endIdx][this.deg[endIdx]] = bondIdx++;
            int n = begIdx;
            this.deg[n] = this.deg[n] + 1;
            int n2 = endIdx;
            this.deg[n2] = this.deg[n2] + 1;
        }
        for (int atomIdx = 0; atomIdx < numAtoms; ++atomIdx) {
            this.aexpr[atomIdx] = this.encodeAtomExpr(atomIdx);
        }
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode specified!");
            }
        }
        this.mode = mode;
        int numAtoms = this.mol.getAtomCount();
        for (int atomIdx = 0; atomIdx < numAtoms; ++atomIdx) {
            this.aexpr[atomIdx] = this.encodeAtomExpr(atomIdx);
        }
    }

    public String generate(int[] atomIdxs) {
        if (atomIdxs == null) {
            throw new NullPointerException("No atom indexes provided");
        }
        if (atomIdxs.length == 0) {
            return null;
        }
        if (atomIdxs.length == 1 && this.mode == 2) {
            return this.aexpr[atomIdxs[0]];
        }
        Arrays.fill(this.rbnds, 0);
        Arrays.fill(this.avisit, 0);
        for (int atmIdx : atomIdxs) {
            this.avisit[atmIdx] = -1;
        }
        this.numVisit = 1;
        for (int atomIdx : atomIdxs) {
            if (this.avisit[atomIdx] >= 0) continue;
            this.markRings(atomIdx, -1);
        }
        this.numVisit = 1;
        for (int atmIdx : atomIdxs) {
            this.avisit[atmIdx] = -1;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < atomIdxs.length; ++i) {
            if (this.avisit[atomIdxs[i]] >= 0) continue;
            if (i > 0) {
                sb.append('.');
            }
            this.encodeExpr(atomIdxs[i], -1, sb);
        }
        return sb.toString();
    }

    private void markRings(int idx, int bprev) {
        ++this.numVisit;
        int d = this.deg[idx];
        for (int j = 0; j < d; ++j) {
            int nbr = this.atomAdj[idx][j];
            int bidx = this.bondAdj[idx][j];
            if (this.avisit[nbr] == 0 || bidx == bprev) continue;
            if (this.avisit[nbr] < 0) {
                this.markRings(nbr, bidx);
                continue;
            }
            if (this.avisit[nbr] >= this.avisit[idx]) continue;
            this.rbnds[bidx] = -1;
        }
    }

    private void encodeExpr(int idx, int bprev, StringBuilder sb) {
        int bidx;
        int nbr;
        int j;
        int d;
        ++this.numVisit;
        sb.append(this.aexpr[idx]);
        int remain = d = this.deg[idx];
        for (j = 0; j < d; ++j) {
            int rnum;
            nbr = this.atomAdj[idx][j];
            bidx = this.bondAdj[idx][j];
            if (this.rbnds[bidx] < 0) {
                rnum = this.chooseRingNumber();
                if (rnum > 9) {
                    sb.append('%');
                }
                sb.append(rnum);
                this.rbnds[bidx] = rnum;
            } else if (this.rbnds[bidx] > 0) {
                rnum = this.rbnds[bidx];
                this.releaseRingNumber(rnum);
                if (rnum > 9) {
                    sb.append('%');
                }
                sb.append(rnum);
            }
            if ((this.mode != 2 || this.avisit[nbr] != 0) && bidx != bprev && this.rbnds[bidx] == 0) continue;
            --remain;
        }
        for (j = 0; j < d; ++j) {
            nbr = this.atomAdj[idx][j];
            bidx = this.bondAdj[idx][j];
            if (this.mode == 2 && this.avisit[nbr] == 0 || bidx == bprev || this.rbnds[bidx] != 0) continue;
            --remain;
            if (this.avisit[nbr] == 0) {
                if (remain > 0) {
                    sb.append('(');
                }
                sb.append(this.bexpr[bidx]);
                sb.append(this.mol.getAtom(nbr).isAromatic() ? (char)'a' : '*');
                if (remain <= 0) continue;
                sb.append(')');
                continue;
            }
            if (remain > 0) {
                sb.append('(');
            }
            sb.append(this.bexpr[bidx]);
            this.encodeExpr(nbr, bidx, sb);
            if (remain <= 0) continue;
            sb.append(')');
        }
    }

    private int chooseRingNumber() {
        for (int i = 1; i < this.rnums.length; ++i) {
            if (this.rnums[i] != 0) continue;
            this.rnums[i] = 1;
            return i;
        }
        throw new IllegalStateException("No more ring numbers available!");
    }

    private void releaseRingNumber(int rnum) {
        this.rnums[rnum] = 0;
    }

    private String encodeAtomExpr(int atmIdx) {
        Integer chg;
        IAtom atom = this.mol.getAtom(atmIdx);
        boolean complex = this.mode == 2;
        StringBuilder sb = new StringBuilder();
        switch (atom.getAtomicNumber()) {
            case 0: {
                sb.append('*');
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 35: 
            case 53: {
                sb.append(atom.isAromatic() ? atom.getSymbol().toLowerCase(Locale.ROOT) : atom.getSymbol());
                break;
            }
            default: {
                complex = true;
                sb.append(atom.isAromatic() ? atom.getSymbol().toLowerCase(Locale.ROOT) : atom.getSymbol());
            }
        }
        if (this.mode == 2) {
            int hcount;
            int valence = hcount = atom.getImplicitHydrogenCount().intValue();
            int connections = hcount;
            int atmDeg = this.deg[atmIdx];
            for (int i = 0; i < atmDeg; ++i) {
                int bord;
                IBond bond = this.mol.getBond(this.bondAdj[atmIdx][i]);
                IAtom nbr = bond.getOther(atom);
                if (nbr.getAtomicNumber() != null && nbr.getAtomicNumber() == 1) {
                    ++hcount;
                }
                int n = bord = bond.getOrder() != null ? bond.getOrder().numeric() : 0;
                if (bord == 0) {
                    throw new IllegalArgumentException("Molecule had unsupported zero-order or unset bonds!");
                }
                valence += bord;
                ++connections;
            }
            sb.append('H').append(hcount);
            sb.append('v').append(valence);
            sb.append('X').append(connections);
        }
        if ((chg = atom.getFormalCharge()) == null) {
            chg = 0;
        }
        if (chg <= -1 || chg >= 1) {
            if (chg >= 0) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            int abs = Math.abs(chg);
            if (abs > 1) {
                sb.append(abs);
            }
            complex = true;
        } else if (this.mode == 2) {
            sb.append("+0");
        }
        return complex ? '[' + sb.toString() + ']' : sb.toString();
    }

    private String encodeBondExpr(int bondIdx, int beg, int end) {
        IBond bond = this.mol.getBond(bondIdx);
        if (bond.getOrder() == null) {
            return "";
        }
        boolean bArom = bond.isAromatic();
        boolean aArom = this.mol.getAtom(beg).isAromatic() && this.mol.getAtom(end).isAromatic();
        switch (bond.getOrder()) {
            case SINGLE: {
                if (bArom) {
                    return aArom ? "" : ":";
                }
                return aArom ? "-" : "";
            }
            case DOUBLE: {
                return bArom ? "" : "=";
            }
            case TRIPLE: {
                return "#";
            }
        }
        throw new IllegalArgumentException("Unsupported bond type: " + bond.getOrder());
    }
}

