/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat.Item;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat.myDataset;

public class EclatProcess {
    private double minSupport;
    private double minConfidence;
    private myDataset dataset;
    private int nAttr;
    private int nTrans;
    private Item root;
    private int nFrequentItemsets;
    private int nCoveredRecords;

    public EclatProcess(myDataset dataset, double minSupport, double minConfidence) {
        this.minSupport = minSupport;
        this.minConfidence = minConfidence;
        this.dataset = dataset;
        this.nAttr = dataset.getnVars();
        this.nTrans = dataset.getnTrans();
        this.root = new Item(-1);
    }

    public void run() {
        this.generateFirstCandidates();
        this.nFrequentItemsets = this.generateCandidates(this.root, new ArrayList<Item>(), 1);
    }

    public ArrayList<AssociationRule> generateRulesSet() {
        ArrayList<AssociationRule> rules = new ArrayList<AssociationRule>();
        HashSet<Integer> covered_records = new HashSet<Integer>();
        this.generateRules(this.root, new ArrayList<Item>(), rules, covered_records);
        this.nCoveredRecords = covered_records.size();
        return rules;
    }

    public void printReport(ArrayList<AssociationRule> rules) {
        double avg_sup = 0.0;
        double avg_yulesQ = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        double avg_ant_length = 0.0;
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getRuleSupport();
            avg_conf += ar.getConfidence();
            avg_lift += ar.getLift();
            avg_conv += ar.getConv();
            avg_CF += ar.getCF();
            avg_netConf += ar.getNetConf();
            avg_yulesQ += ar.getYulesQ();
            avg_ant_length += (double)(ar.getAntecedent().size() + ar.getConsequent().size());
        }
        System.out.println("\nNumber of Frequent Itemsets found: " + this.nFrequentItemsets);
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            System.out.println("Average Support: " + EclatProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + EclatProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Lift: " + EclatProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + EclatProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + EclatProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + EclatProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average YulesQ: " + EclatProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + EclatProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Number of Covered Records (%): " + EclatProcess.roundDouble(100.0 * (double)this.nCoveredRecords / (double)this.nTrans, 2));
        }
    }

    public static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public String printRules(ArrayList<AssociationRule> rules) {
        boolean stop = false;
        String rulesList = "";
        rulesList = rulesList + "\n\nNumber of trials = x\n\n";
        rulesList = rulesList + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < rules.size() && !stop; ++i) {
            int lenghtrule = rules.get(i).getAntecedent().size() + rules.get(i).getConsequent().size();
            rulesList = rulesList + "" + EclatProcess.roundDouble(rules.get(i).getRuleSupport(), 2) + "\t" + EclatProcess.roundDouble(rules.get(i).getAntecedentSupport(), 2) + "\t" + EclatProcess.roundDouble(rules.get(i).getConsequentSupport(), 2) + "\t" + EclatProcess.roundDouble(rules.get(i).getConfidence(), 2) + "\t" + EclatProcess.roundDouble(rules.get(i).getLift(), 2) + "\t" + EclatProcess.roundDouble(rules.get(i).getConv(), 2) + "\t" + EclatProcess.roundDouble(rules.get(i).getCF(), 2) + "\t" + EclatProcess.roundDouble(rules.get(i).getNetConf(), 2) + "\t" + EclatProcess.roundDouble(rules.get(i).getYulesQ(), 2) + "\t" + lenghtrule + "\n";
        }
        rulesList = rulesList + "\nFrequent\n";
        return rulesList;
    }

    public void saveReport(ArrayList<AssociationRule> rules, PrintWriter w) {
        double avg_sup = 0.0;
        double avg_yulesQ = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        double avg_ant_length = 0.0;
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getRuleSupport();
            avg_conf += ar.getConfidence();
            avg_lift += ar.getLift();
            avg_conv += ar.getConv();
            avg_CF += ar.getCF();
            avg_netConf += ar.getNetConf();
            avg_yulesQ += ar.getYulesQ();
            avg_ant_length += (double)(ar.getAntecedent().size() + ar.getConsequent().size());
        }
        w.println("\nNumber of Frequent Itemsets found: " + this.nFrequentItemsets);
        System.out.println("\nNumber of Frequent Itemsets found: " + this.nFrequentItemsets);
        w.println("\nNumber of Association Rules generated: " + rules.size());
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            w.println("Average Support: " + EclatProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Support: " + EclatProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            w.println("Average Confidence: " + EclatProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + EclatProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            w.println("Average Lift: " + EclatProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Lift: " + EclatProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            w.println("Average Conviction: " + EclatProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + EclatProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            w.println("Average Certain Factor: " + EclatProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + EclatProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            w.println("Average Netconf: " + EclatProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + EclatProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            w.println("Average YulesQ: " + EclatProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average YulesQ: " + EclatProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            w.println("Average Number of Antecedents: " + EclatProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + EclatProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            w.println("Number of Covered Records (%): " + EclatProcess.roundDouble(100.0 * (double)this.nCoveredRecords / (double)this.nTrans, 2));
            System.out.println("Number of Covered Records (%): " + EclatProcess.roundDouble(100.0 * (double)this.nCoveredRecords / (double)this.nTrans, 2));
        } else {
            w.println("Average Support: 0.0");
            System.out.println("Average Support: 0.0");
            w.println("Average Confidence: 0.0");
            System.out.println("Average Confidence: 0.0");
            w.println("Average Lift: 0.0");
            System.out.println("Average Lift: 0.0");
            w.println("Average Conviction: 0.0");
            System.out.println("Average Conviction: 0.0");
            w.println("Average Certain Factor: 0.0");
            System.out.println("Average Certain Factor: 0.0");
            w.println("Average Netconf: 0.0");
            System.out.println("Average Netconf: 0.0");
            w.println("Average YulesQ: 0.0");
            System.out.println("Average YulesQ: 0.0");
            w.println("Average Number of Antecedents: 0.0");
            System.out.println("Average Number of Antecedents: 0.0");
            w.println("Number of Covered Records (%): 0.0");
            System.out.println("Number of Covered Records (%): 0.0");
        }
    }

    private void generateFirstCandidates() {
        Enumeration<Integer> keys = this.dataset.getTIDList().keys();
        while (keys.hasMoreElements()) {
            this.root.addChild(new Item(keys.nextElement()));
        }
    }

    private int generateCandidates(Item item, ArrayList<Item> current, int depth) {
        int generated = 0;
        ArrayList<Item> v = item.getChildren();
        ArrayList<Item> v_tmp = new ArrayList<Item>(v);
        for (int i = 0; i < v_tmp.size(); ++i) {
            Item child = v_tmp.get(i);
            current.add(child);
            int sup = this.countSupport(current);
            if ((double)sup / (double)this.nTrans >= this.minSupport) {
                child.setSupport(sup);
                if (depth < this.nAttr) {
                    this.copySiblings(child, v);
                    generated += this.generateCandidates(child, current, depth + 1);
                }
                ++generated;
            } else {
                v.remove(child);
            }
            current.remove(child);
        }
        return generated;
    }

    private void copySiblings(Item item, ArrayList<Item> siblings) {
        int mod_item = item.getLabel() % this.nAttr;
        for (int i = 0; i < siblings.size(); ++i) {
            Item sibling = siblings.get(i);
            int mod_sibling = sibling.getLabel() % this.nAttr;
            if (mod_sibling <= mod_item) continue;
            item.addChild(new Item(sibling.getLabel()));
        }
    }

    private int countSupport(ArrayList<Item> itemset) {
        return this.countCoveredRecords(itemset).size();
    }

    private void generateRules(Item item, ArrayList<Item> itemset, ArrayList<AssociationRule> rules, HashSet<Integer> cov_recs) {
        ArrayList<Item> v = item.getChildren();
        for (int f = 0; f < v.size(); ++f) {
            item = v.get(f);
            itemset.add(item);
            if (itemset.size() > 1) {
                for (int i = 0; i < itemset.size(); ++i) {
                    int j;
                    ArrayList<Item> ant = new ArrayList<Item>();
                    for (j = 0; j < itemset.size(); ++j) {
                        if (i == j) continue;
                        ant.add(itemset.get(j));
                    }
                    double rule_sup = (double)item.getSupport() / (double)this.nTrans;
                    double ant_sup = (double)this.searchItemsetIntoTrie(this.root, ant, 0) / (double)this.nTrans;
                    double cons_sup = (double)itemset.get(i).getSupport() / (double)this.nTrans;
                    double conf = rule_sup / ant_sup;
                    double lift = cons_sup == 0.0 || ant_sup == 0.0 ? 1.0 : rule_sup / (ant_sup * cons_sup);
                    double conv = cons_sup == 1.0 || ant_sup == 0.0 ? 1.0 : ant_sup * (1.0 - cons_sup) / (ant_sup - rule_sup);
                    double netConf = ant_sup == 0.0 || ant_sup == 1.0 || Math.abs(ant_sup * (1.0 - ant_sup)) <= 0.001 ? 0.0 : (rule_sup - ant_sup * cons_sup) / (ant_sup * (1.0 - ant_sup));
                    double numeratorYules = rule_sup * (1.0 - cons_sup - ant_sup + rule_sup) - (ant_sup - rule_sup) * (cons_sup - rule_sup);
                    double denominatorYules = rule_sup * (1.0 - cons_sup - ant_sup + rule_sup) + (ant_sup - rule_sup) * (cons_sup - rule_sup);
                    double yulesQ = ant_sup == 0.0 || ant_sup == 1.0 || cons_sup == 0.0 || cons_sup == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
                    double CF = 0.0;
                    if (conf > cons_sup) {
                        CF = (conf - cons_sup) / (1.0 - cons_sup);
                    } else if (conf < cons_sup) {
                        CF = (conf - cons_sup) / cons_sup;
                    }
                    if (!(conf >= this.minConfidence)) continue;
                    AssociationRule ar = new AssociationRule();
                    for (j = 0; j < ant.size(); ++j) {
                        ar.addAntecedent(ant.get(j).getLabel());
                    }
                    ar.addConsequent(itemset.get(i).getLabel());
                    ar.setRuleSupport(rule_sup);
                    ar.setAntecedentSupport(ant_sup);
                    ar.setConsequentSupport(cons_sup);
                    ar.setConfidence(conf);
                    ar.setLift(lift);
                    ar.setConv(conv);
                    ar.setCF(CF);
                    ar.setNetConf(netConf);
                    ar.setYulesQ(yulesQ);
                    cov_recs.addAll(this.countCoveredRecords(itemset));
                    rules.add(ar);
                }
            }
            if (item.hasChildren()) {
                this.generateRules(item, itemset, rules, cov_recs);
            }
            itemset.remove(item);
        }
    }

    private int searchItemsetIntoTrie(Item item, ArrayList<Item> itemset, int index) {
        int support = 0;
        ArrayList<Item> v = item.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            item = v.get(i);
            if (!item.equals(itemset.get(index))) continue;
            if (index == itemset.size() - 1) {
                return item.getSupport();
            }
            if (!item.hasChildren()) break;
            support = this.searchItemsetIntoTrie(item, itemset, index + 1);
            break;
        }
        return support;
    }

    private HashSet<Integer> countCoveredRecords(ArrayList<Item> itemset) {
        ArrayList<HashSet<Integer>> v_tid_lst = new ArrayList<HashSet<Integer>>();
        for (int i = 0; i < itemset.size(); ++i) {
            Item item = itemset.get(i);
            v_tid_lst.add(this.dataset.getTIDList().get(item.getLabel()));
        }
        HashSet<Integer> toIntersect = new HashSet<Integer>((Collection)v_tid_lst.get(0));
        for (int k = 1; k < v_tid_lst.size(); ++k) {
            toIntersect.retainAll((Collection)v_tid_lst.get(k));
            if (toIntersect.isEmpty()) break;
        }
        return toIntersect;
    }
}

