/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCMAR;

import java.io.IOException;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.AprioriTFP_CMAR;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.myDataset;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.parseParameters;
import org.core.Files;

public class CMAR {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String fileDB;
    String fileRB;
    String fileTime;
    String fileHora;
    String data;
    DataBase dataBase;
    AprioriTFP_CMAR newClassification;
    long startTime = System.currentTimeMillis();
    long totalTime;
    double minConf;
    double minSup;
    int delta;
    private boolean somethingWrong = false;

    public CMAR(parseParameters parameters) {
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasMissingAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.fileDB = parameters.getOutputFile(0);
        this.fileRB = parameters.getOutputFile(1);
        this.data = parameters.getTrainingInputFile();
        this.fileTime = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/hora.txt";
        this.minConf = Double.parseDouble(parameters.getParameter(0)) * 100.0;
        this.minSup = Double.parseDouble(parameters.getParameter(1)) * 100.0;
        this.delta = Integer.parseInt(parameters.getParameter(2));
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, either the data-set has missing values.");
            System.err.println("Please remove the examples with missing data or apply a MV preprocessing.");
            System.err.println("Aborting the program");
        } else {
            this.dataBase = new DataBase(this.train);
            this.newClassification = new AprioriTFP_CMAR(this.minConf, this.minSup, this.delta);
            this.newClassification.inputDataSet(this.train, this.dataBase);
            this.newClassification.testDataSet(this.test, this.dataBase);
            this.newClassification.startCMARclassification();
            this.dataBase.saveFile(this.fileDB);
            this.newClassification.getCurrentRuleListObject().outputCMARrules(this.fileRB);
            this.doOutputTra(this.outputTr);
            this.doOutputTst(this.outputTst);
            this.totalTime = System.currentTimeMillis() - this.startTime;
            this.writeTime();
            System.out.println("Algorithm Finished");
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.data + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.data + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void doOutputTra(String filename) {
        String output = new String("");
        output = this.train.copyHeader();
        for (int i = 0; i < this.train.getnData(); ++i) {
            output = output + this.train.getOutputAsString(i) + " " + this.classificationOutput(this.newClassification.dataArray[i]) + "\n";
        }
        Files.writeFile(filename, output);
    }

    private void doOutputTst(String filename) {
        String output = new String("");
        output = this.test.copyHeader();
        for (int i = 0; i < this.test.getnData(); ++i) {
            output = output + this.test.getOutputAsString(i) + " " + this.classificationOutput(this.newClassification.testDataArray[i]) + "\n";
        }
        Files.writeFile(filename, output);
    }

    private String classificationOutput(short[] example) {
        String output = new String("?");
        short clas = this.newClassification.currentRlist.classifyRecordWCS(example);
        if (clas > 0) {
            output = this.train.getOutputValue(clas - this.dataBase.getOrderClas());
        }
        return output;
    }
}

