/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.calendars.DefaultGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.List;

public class GregorianCalendarVariables
implements ITradingDaysVariable,
Cloneable {
    private final IGregorianCalendarProvider m_provider;
    private TradingDaysType m_dkind = TradingDaysType.None;

    public static GregorianCalendarVariables getDefault(TradingDaysType dkind) {
        GregorianCalendarVariables vars = new GregorianCalendarVariables(DefaultGregorianCalendarProvider.instance, dkind);
        return vars;
    }

    public GregorianCalendarVariables(IGregorianCalendarProvider provider, TradingDaysType dkind) {
        this.m_provider = provider;
        this.m_dkind = dkind;
    }

    public GregorianCalendarVariables clone() {
        try {
            GregorianCalendarVariables cal = (GregorianCalendarVariables)super.clone();
            return cal;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        this.m_provider.calendarData(this.m_dkind, domain, data);
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return null;
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return TsFrequency.Undefined;
    }

    @Override
    public String getDescription(TsFrequency context) {
        switch (this.m_dkind) {
            case WorkingDays: {
                return "Working days";
            }
            case TradingDays: {
                return "Trading days";
            }
        }
        return "";
    }

    @Override
    public int getDim() {
        return this.m_provider.count(this.m_dkind);
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        int ntd = this.m_provider.count(this.m_dkind);
        if (idx < ntd) {
            return this.m_provider.getDescription(this.m_dkind, idx);
        }
        return null;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return true;
    }

    public TradingDaysType getDayOfWeek() {
        return this.m_dkind;
    }

    public void setDayOfWeek(TradingDaysType dtype) {
        this.m_dkind = dtype;
    }

    public IGregorianCalendarProvider getProvider() {
        return this.m_provider;
    }
}

