/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;

public class MathFunctionUtil {
    public static double H = 1.0E-6;
    public static int NUMINTERVALS = 10000;

    private MathFunctionUtil() {
    }

    public static double derivative(MathFunction mathFunction, double d) {
        if (mathFunction instanceof MathFunctionWithFirstDerivative) {
            return ((MathFunctionWithFirstDerivative)mathFunction).derivative(d);
        }
        if (mathFunction instanceof MathFunctionWithDerivative) {
            return ((MathFunctionWithDerivative)mathFunction).derivative(d, 1);
        }
        return MathFunctionUtil.finiteCenteredDifferenceDerivative(mathFunction, d, H);
    }

    public static double derivative(MathFunction mathFunction, double d, int n) {
        if (n == 0) {
            return mathFunction.evaluate(d);
        }
        if (n == 1) {
            return MathFunctionUtil.derivative(mathFunction, d);
        }
        if (mathFunction instanceof MathFunctionWithDerivative) {
            return ((MathFunctionWithDerivative)mathFunction).derivative(d, n);
        }
        if (n % 2 == 0) {
            return MathFunctionUtil.finiteCenteredDifferenceDerivative(mathFunction, d, n, H);
        }
        return MathFunctionUtil.finiteDifferenceDerivative(mathFunction, d, n, H);
    }

    public static double finiteDifferenceDerivative(MathFunction mathFunction, double d, int n, double d2) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }
        if (n == 0) {
            return mathFunction.evaluate(d);
        }
        double d3 = Math.pow(d2, 1.0 / (double)n);
        double[] dArray = new double[n + 1];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = mathFunction.evaluate(d + (double)n2 * d3);
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < n - n2; ++i) {
                dArray[i] = dArray[i + 1] - dArray[i];
            }
        }
        return dArray[0] / d2;
    }

    public static double finiteCenteredDifferenceDerivative(MathFunction mathFunction, double d, double d2) {
        double d3 = mathFunction.evaluate(d + d2);
        double d4 = mathFunction.evaluate(d - d2);
        return (d3 - d4) / (2.0 * d2);
    }

    public static double finiteCenteredDifferenceDerivative(MathFunction mathFunction, double d, int n, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }
        if (n == 0) {
            return mathFunction.evaluate(d);
        }
        if (n % 2 == 1) {
            throw new IllegalArgumentException("n must be even");
        }
        double d3 = Math.pow(d2, 1.0 / (double)n);
        return MathFunctionUtil.finiteDifferenceDerivative(mathFunction, d - (double)n * d3 / 2.0, n, d2);
    }

    public static double[][] removeNaNs(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!Double.isNaN(dArray[i]) && !Double.isNaN(dArray2[i])) continue;
            ++n;
        }
        if (n == 0) {
            return new double[][]{dArray, dArray2};
        }
        double[] dArray3 = new double[dArray.length - n];
        double[] dArray4 = new double[dArray2.length - n];
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isNaN(dArray2[i])) continue;
            dArray3[n2] = dArray[i];
            dArray4[n2++] = dArray2[i];
        }
        return new double[][]{dArray3, dArray4};
    }

    public static double integral(MathFunction mathFunction, double d, double d2) {
        if (mathFunction instanceof MathFunctionWithIntegral) {
            return ((MathFunctionWithIntegral)mathFunction).integral(d, d2);
        }
        return MathFunctionUtil.simpsonIntegral(mathFunction, d, d2, NUMINTERVALS);
    }

    public static double simpsonIntegral(MathFunction mathFunction, double d, double d2, int n) {
        if (n % 2 != 0) {
            throw new IllegalArgumentException("numIntervals must be an even number");
        }
        if (Double.isInfinite(d) || Double.isInfinite(d2) || Double.isNaN(d) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("a and b must not be infinite or NaN");
        }
        if (d2 < d) {
            throw new IllegalArgumentException("b < a");
        }
        if (d == d2) {
            return 0.0;
        }
        double d3 = (d2 - d) / (double)n;
        double d4 = 2.0 * d3;
        int n2 = n / 2;
        double d5 = 0.0;
        for (int i = 0; i < n2 - 1; ++i) {
            double d6 = d + d3 + 2.0 * d3 * (double)i;
            d5 += 4.0 * mathFunction.evaluate(d6) + 2.0 * mathFunction.evaluate(d6 + d3);
        }
        return (d5 += mathFunction.evaluate(d) + mathFunction.evaluate(d2) + 4.0 * mathFunction.evaluate(d2 - d3)) * d3 / 3.0;
    }
}

