/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu.twosample;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.rosuda.deducer.menu.twosample.TwoSampleModel;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class TestOptions
extends JDialog
implements ActionListener {
    private JPanel alternativePanel;
    private JRadioButton twoSided;
    private JRadioButton greater;
    private JTextField confLevel;
    private ButtonGroup alternative;
    private JPanel navPanel;
    private JTextField digits;
    private JLabel digitLabel;
    private JPanel outputPanel;
    private JCheckBox descriptives;
    private JLabel percLabel;
    private JLabel ConfidenceLabel;
    private JRadioButton lessThan;
    private TwoSampleModel.OptionsModel model;

    public TestOptions(JDialog jDialog, TwoSampleModel.OptionsModel optionsModel) {
        super(jDialog);
        this.initGUI();
        this.model = optionsModel;
        this.reset();
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.alternativePanel = new JPanel();
            this.getContentPane().add(this.alternativePanel);
            this.alternativePanel.setLayout(null);
            this.alternativePanel.setBounds(32, 12, 202, 99);
            this.alternativePanel.setBorder(BorderFactory.createTitledBorder("Alternative"));
            this.twoSided = new JRadioButton();
            this.alternativePanel.add(this.twoSided);
            this.twoSided.setText("Two-sided");
            this.twoSided.setBounds(17, 20, 180, 19);
            this.lessThan = new JRadioButton();
            this.alternativePanel.add(this.lessThan);
            this.lessThan.setText("Less");
            this.lessThan.setBounds(17, 45, 180, 19);
            this.greater = new JRadioButton();
            this.alternativePanel.add(this.greater);
            this.greater.setText("Greater");
            this.greater.setBounds(17, 70, 168, 19);
            this.ConfidenceLabel = new JLabel();
            this.getContentPane().add(this.ConfidenceLabel);
            this.ConfidenceLabel.setText("Confidence Level:");
            this.ConfidenceLabel.setBounds(49, 123, 120, 15);
            this.confLevel = new JTextField();
            this.getContentPane().add(this.getConfLevel());
            this.confLevel.setText("95");
            this.confLevel.setBounds(166, 119, 46, 22);
            this.percLabel = new JLabel();
            this.getContentPane().add(this.percLabel);
            this.percLabel.setText("%");
            this.percLabel.setBounds(217, 123, 17, 15);
            this.outputPanel = new JPanel();
            this.getContentPane().add(this.outputPanel);
            this.getContentPane().add(this.getNavPanel());
            this.outputPanel.setLayout(null);
            this.outputPanel.setBounds(32, 148, 202, 90);
            this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
            this.descriptives = new JCheckBox();
            this.outputPanel.add(this.descriptives);
            this.descriptives.setText("Descriptive Table");
            this.descriptives.setBounds(17, 20, 154, 19);
            this.digitLabel = new JLabel();
            this.outputPanel.add(this.digitLabel);
            this.digitLabel.setText(" Digits:");
            this.digitLabel.setBounds(17, 55, 60, 15);
            this.digits = new JTextField();
            this.outputPanel.add(this.digits);
            this.digits.setText("<auto>");
            this.digits.setBounds(67, 51, 68, 22);
            this.getAlternative();
            this.setTitle("Test Options");
            this.setResizable(false);
            this.setSize(268, 310);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JTextField getConfLevel() {
        return this.confLevel;
    }

    private ButtonGroup getAlternative() {
        if (this.alternative == null) {
            this.alternative = new ButtonGroup();
            this.alternative.add(this.twoSided);
            this.alternative.add(this.lessThan);
            this.alternative.add(this.greater);
        }
        return this.alternative;
    }

    private JPanel getNavPanel() {
        if (this.navPanel == null) {
            this.navPanel = new OkayCancelPanel(false, false, this);
            this.navPanel.setBounds(50, 244, 206, 50);
        }
        return this.navPanel;
    }

    public void reset() {
        if (this.model.alternative == "two.sided") {
            this.twoSided.setSelected(true);
        } else if (this.model.alternative == "less") {
            this.lessThan.setSelected(true);
        } else {
            this.greater.setSelected(true);
        }
        this.confLevel.setText(Double.toString(this.model.confLevel * 100.0));
        this.digits.setText(this.model.digits);
        this.descriptives.setSelected(this.model.descriptives);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            double d;
            try {
                d = Double.parseDouble(this.confLevel.getText());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Confidence Level: Please enter a number between 0 and 100");
                return;
            }
            if (d < 0.0 || d > 100.0) {
                JOptionPane.showMessageDialog(this, "Confidence Level: Please enter a number between 0 and 100");
                return;
            }
            this.model.confLevel = d / 100.0;
            String string2 = this.digits.getText();
            int n = 0;
            if (!string2.equals("<auto>")) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Digits: Please enter a number.");
                    return;
                }
                if (n < 0) {
                    JOptionPane.showMessageDialog(this, "Digits: Please enter a positive integer.");
                    return;
                }
            }
            this.model.digits = string2;
            this.model.descriptives = this.descriptives.isSelected();
            this.model.alternative = this.twoSided.isSelected() ? "two.sided" : (this.lessThan.isSelected() ? "less" : "greater");
            this.dispose();
        }
        if (string == "Cancel") {
            this.dispose();
        }
    }
}

