/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.continuous.MultivariateElasticModel;
import dr.evomodel.treedatalikelihood.continuous.AbstractDriftDiffusionModelDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.cdi.ContinuousDiffusionIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.MultivariateIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.SafeMultivariateActualizedWithDriftIntegrator;
import dr.evomodel.treedatalikelihood.preorder.BranchSufficientStatistics;
import dr.inference.model.Model;
import dr.math.matrixAlgebra.missingData.MissingOps;
import java.util.List;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class OUDiffusionModelDelegate
extends AbstractDriftDiffusionModelDelegate {
    private MultivariateElasticModel elasticModel;

    public OUDiffusionModelDelegate(Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, List<BranchRateModel> list, MultivariateElasticModel multivariateElasticModel) {
        this(tree, multivariateDiffusionModel, list, multivariateElasticModel, 0);
    }

    private OUDiffusionModelDelegate(Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, List<BranchRateModel> list, MultivariateElasticModel multivariateElasticModel, int n) {
        super(tree, multivariateDiffusionModel, list, n);
        this.elasticModel = multivariateElasticModel;
        this.addModel(multivariateElasticModel);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.elasticModel) {
            this.fireModelChanged(model);
        } else {
            super.handleModelChangedEvent(model, object, n);
        }
    }

    @Override
    public boolean hasDrift() {
        return true;
    }

    @Override
    public boolean hasActualization() {
        return true;
    }

    @Override
    public boolean hasDiagonalActualization() {
        return this.elasticModel.isDiagonal();
    }

    public boolean isSymmetric() {
        return this.elasticModel.isSymmetric();
    }

    public double[][] getStrengthOfSelection() {
        return this.elasticModel.getStrengthOfSelectionMatrix();
    }

    public double[] getEigenValuesStrengthOfSelection() {
        return this.elasticModel.getEigenValuesStrengthOfSelection();
    }

    public double[] getEigenVectorsStrengthOfSelection() {
        return this.elasticModel.getEigenVectorsStrengthOfSelection();
    }

    @Override
    public void setDiffusionModels(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, boolean bl) {
        super.setDiffusionModels(continuousDiffusionIntegrator, bl);
        continuousDiffusionIntegrator.setDiffusionStationaryVariance(this.getEigenBufferOffsetIndex(0), this.getEigenValuesStrengthOfSelection(), this.getEigenVectorsStrengthOfSelection());
    }

    @Override
    public void updateDiffusionMatrices(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int[] nArray, double[] dArray, int n, boolean bl) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            if (bl) {
                this.flipMatrixBufferOffset(nArray[i]);
            }
            nArray2[i] = this.getMatrixBufferOffsetIndex(nArray[i]);
        }
        continuousDiffusionIntegrator.updateOrnsteinUhlenbeckDiffusionMatrices(this.getEigenBufferOffsetIndex(0), nArray2, dArray, this.getDriftRates(nArray, n), this.getEigenValuesStrengthOfSelection(), this.getEigenVectorsStrengthOfSelection(), n);
    }

    @Override
    public DenseMatrix64F getGradientVarianceWrtVariance(NodeRef nodeRef, ContinuousDiffusionIntegrator continuousDiffusionIntegrator, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, DenseMatrix64F denseMatrix64F) {
        if (this.tree.isRoot(nodeRef)) {
            return super.getGradientVarianceWrtVariance(nodeRef, continuousDiffusionIntegrator, continuousDataLikelihoodDelegate, denseMatrix64F);
        }
        DenseMatrix64F denseMatrix64F2 = denseMatrix64F.copy();
        if (this.hasDiagonalActualization()) {
            this.actualizeGradientDiagonal(continuousDiffusionIntegrator, nodeRef.getNumber(), denseMatrix64F2);
        } else {
            this.actualizeGradient(continuousDiffusionIntegrator, nodeRef.getNumber(), denseMatrix64F2);
        }
        return denseMatrix64F2;
    }

    private void actualizeGradient(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, DenseMatrix64F denseMatrix64F) {
        double[] dArray = this.elasticModel.getEigenVectorsStrengthOfSelection();
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(dArray, 0, this.dim, this.dim);
        SafeMultivariateActualizedWithDriftIntegrator.transformMatrix(denseMatrix64F, denseMatrix64F2, this.elasticModel.isSymmetric());
        this.actualizeGradientDiagonal(continuousDiffusionIntegrator, n, denseMatrix64F);
        SafeMultivariateActualizedWithDriftIntegrator.transformMatrixBack(denseMatrix64F, denseMatrix64F2);
    }

    private void actualizeGradientDiagonal(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, DenseMatrix64F denseMatrix64F) {
        double[] dArray = this.elasticModel.getEigenValuesStrengthOfSelection();
        double d = continuousDiffusionIntegrator.getBranchLength(this.getMatrixBufferOffsetIndex(n));
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                denseMatrix64F.unsafe_set(i, j, OUDiffusionModelDelegate.factorFunction(dArray[i] + dArray[j], d) * denseMatrix64F.unsafe_get(i, j));
            }
        }
    }

    private static double factorFunction(double d, double d2) {
        if (d == 0.0) {
            return d2;
        }
        return -Math.expm1(-d * d2) / d;
    }

    DenseMatrix64F getGradientVarianceWrtAttenuation(NodeRef nodeRef, ContinuousDiffusionIntegrator continuousDiffusionIntegrator, BranchSufficientStatistics branchSufficientStatistics, DenseMatrix64F denseMatrix64F) {
        assert (!this.tree.isRoot(nodeRef)) : "Gradient wrt actualization is not available for the root.";
        if (this.hasDiagonalActualization()) {
            return this.getGradientVarianceWrtAttenuationDiagonal(continuousDiffusionIntegrator, branchSufficientStatistics, nodeRef.getNumber(), denseMatrix64F);
        }
        throw new RuntimeException("not yet implemented");
    }

    private DenseMatrix64F getGradientVarianceWrtAttenuationDiagonal(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, BranchSufficientStatistics branchSufficientStatistics, int n, DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2 = this.getGradientVarianceWrtActualizationDiagonal(continuousDiffusionIntegrator, branchSufficientStatistics, n, denseMatrix64F);
        DenseMatrix64F denseMatrix64F3 = this.getGradientBranchVarianceWrtAttenuationDiagonal(continuousDiffusionIntegrator, n, denseMatrix64F);
        CommonOps.addEquals(denseMatrix64F2, denseMatrix64F3);
        return denseMatrix64F2;
    }

    private DenseMatrix64F getGradientVarianceWrtActualizationDiagonal(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, BranchSufficientStatistics branchSufficientStatistics, int n, DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2 = branchSufficientStatistics.getAbove().getRawVarianceCopy();
        double[] dArray = new double[this.dim * this.dim];
        continuousDiffusionIntegrator.getBranchVariance(this.getMatrixBufferOffsetIndex(n), this.getEigenBufferOffsetIndex(0), dArray);
        DenseMatrix64F denseMatrix64F3 = MissingOps.wrap(dArray, 0, this.dim, this.dim);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dim, this.dim);
        CommonOps.addEquals(denseMatrix64F2, -1.0, denseMatrix64F3);
        CommonOps.multTransB(denseMatrix64F2, denseMatrix64F, denseMatrix64F4);
        CommonOps.scale(2.0, denseMatrix64F4);
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(this.dim, 1);
        CommonOps.extractDiag(denseMatrix64F4, denseMatrix64F5);
        double d = continuousDiffusionIntegrator.getBranchLength(this.getMatrixBufferOffsetIndex(n));
        this.chainRuleActualizationWrtAttenuationDiagonal(d, denseMatrix64F5);
        return denseMatrix64F5;
    }

    private void chainRuleActualizationWrtAttenuationDiagonal(double d, DenseMatrix64F denseMatrix64F) {
        CommonOps.scale(-d, denseMatrix64F);
    }

    private DenseMatrix64F getGradientBranchVarianceWrtAttenuationDiagonal(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, DenseMatrix64F denseMatrix64F) {
        double[] dArray = this.elasticModel.getEigenValuesStrengthOfSelection();
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(((MultivariateIntegrator)continuousDiffusionIntegrator).getVariance(this.getEigenBufferOffsetIndex(0)), 0, this.dim, this.dim);
        double d = continuousDiffusionIntegrator.getBranchLength(this.getMatrixBufferOffsetIndex(n));
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.dim, 1);
        CommonOps.elementMult(denseMatrix64F2, denseMatrix64F);
        for (int i = 0; i < this.dim; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.dim; ++j) {
                d2 -= denseMatrix64F2.unsafe_get(i, j) * this.computeAttenuationFactorActualized(dArray[i] + dArray[j], d);
            }
            denseMatrix64F3.unsafe_set(i, 0, d2);
        }
        return denseMatrix64F3;
    }

    private double computeAttenuationFactorActualized(double d, double d2) {
        if (d == 0.0) {
            return d2 * d2;
        }
        double d3 = Math.expm1(-d * d2);
        return 2.0 * (d3 * d3 - (d3 + d * d2) * Math.exp(-d * d2)) / d / d;
    }

    DenseMatrix64F getGradientDisplacementWrtAttenuation(NodeRef nodeRef, ContinuousDiffusionIntegrator continuousDiffusionIntegrator, BranchSufficientStatistics branchSufficientStatistics, DenseMatrix64F denseMatrix64F) {
        assert (!this.tree.isRoot(nodeRef)) : "Gradient wrt actualization is not available for the root.";
        if (this.hasDiagonalActualization()) {
            return this.getGradientDisplacementWrtAttenuationDiagonal(continuousDiffusionIntegrator, branchSufficientStatistics, nodeRef, denseMatrix64F);
        }
        throw new RuntimeException("not yet implemented");
    }

    private DenseMatrix64F getGradientDisplacementWrtAttenuationDiagonal(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, BranchSufficientStatistics branchSufficientStatistics, NodeRef nodeRef, DenseMatrix64F denseMatrix64F) {
        int n = nodeRef.getNumber();
        DenseMatrix64F denseMatrix64F2 = branchSufficientStatistics.getAbove().getRawMean();
        DenseMatrix64F denseMatrix64F3 = MissingOps.wrap(this.getDriftRate(nodeRef), 0, this.dim, 1);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dim, this.dim);
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(this.dim, 1);
        CommonOps.add(denseMatrix64F2, -1.0, (D1Matrix64F)denseMatrix64F3, (D1Matrix64F)denseMatrix64F5);
        CommonOps.multTransB(denseMatrix64F, denseMatrix64F5, denseMatrix64F4);
        CommonOps.extractDiag(denseMatrix64F4, denseMatrix64F5);
        double d = continuousDiffusionIntegrator.getBranchLength(this.getMatrixBufferOffsetIndex(n));
        this.chainRuleActualizationWrtAttenuationDiagonal(d, denseMatrix64F5);
        return denseMatrix64F5;
    }

    @Override
    DenseMatrix64F getGradientDisplacementWrtDrift(NodeRef nodeRef, ContinuousDiffusionIntegrator continuousDiffusionIntegrator, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2 = denseMatrix64F.copy();
        if (this.hasDiagonalActualization()) {
            this.actualizeDisplacementGradientDiagonal(continuousDiffusionIntegrator, nodeRef.getNumber(), denseMatrix64F2);
        } else {
            this.actualizeDisplacementGradient(continuousDiffusionIntegrator, nodeRef.getNumber(), denseMatrix64F2);
        }
        return denseMatrix64F2;
    }

    private void actualizeDisplacementGradientDiagonal(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, DenseMatrix64F denseMatrix64F) {
        double[] dArray = new double[this.dim];
        continuousDiffusionIntegrator.getBranch1mActualization(this.getMatrixBufferOffsetIndex(n), dArray);
        MissingOps.diagMult(dArray, denseMatrix64F);
    }

    private void actualizeDisplacementGradient(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, DenseMatrix64F denseMatrix64F) {
        double[] dArray = new double[this.dim * this.dim];
        continuousDiffusionIntegrator.getBranch1mActualization(this.getMatrixBufferOffsetIndex(n), dArray);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(dArray, 0, this.dim, this.dim);
        CommonOps.scale(-1.0, denseMatrix64F2);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.dim, 1);
        CommonOps.mult(denseMatrix64F2, denseMatrix64F, denseMatrix64F3);
        CommonOps.scale(-1.0, denseMatrix64F3, denseMatrix64F);
    }

    @Override
    public double[] getGradientDisplacementWrtRoot(NodeRef nodeRef, ContinuousDiffusionIntegrator continuousDiffusionIntegrator, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, DenseMatrix64F denseMatrix64F) {
        boolean bl;
        boolean bl2 = bl = continuousDataLikelihoodDelegate.getRootProcessDelegate().getPseudoObservations() == Double.POSITIVE_INFINITY;
        if (bl && this.tree.isRoot(this.tree.getParent(nodeRef))) {
            return this.actualizeRootGradient(continuousDiffusionIntegrator, nodeRef.getNumber(), denseMatrix64F);
        }
        if (!bl && this.tree.isRoot(nodeRef)) {
            return denseMatrix64F.getData();
        }
        return new double[denseMatrix64F.getNumRows()];
    }

    private double[] actualizeRootGradient(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, DenseMatrix64F denseMatrix64F) {
        if (this.hasDiagonalActualization()) {
            return this.actualizeRootGradientDiagonal(continuousDiffusionIntegrator, n, denseMatrix64F);
        }
        return this.actualizeRootGradientFull(continuousDiffusionIntegrator, n, denseMatrix64F);
    }

    private double[] actualizeRootGradientDiagonal(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, DenseMatrix64F denseMatrix64F) {
        double[] dArray = new double[this.dim];
        continuousDiffusionIntegrator.getBranchActualization(this.getMatrixBufferOffsetIndex(n), dArray);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.dim, 1);
        MissingOps.diagMult(dArray, denseMatrix64F, denseMatrix64F2);
        return denseMatrix64F2.getData();
    }

    private double[] actualizeRootGradientFull(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, DenseMatrix64F denseMatrix64F) {
        double[] dArray = new double[this.dim * this.dim];
        continuousDiffusionIntegrator.getBranchActualization(this.getMatrixBufferOffsetIndex(n), dArray);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(dArray, 0, this.dim, this.dim);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.dim, 1);
        CommonOps.mult(denseMatrix64F2, denseMatrix64F, denseMatrix64F3);
        return denseMatrix64F3.getData();
    }

    @Override
    public double[][] getJointVariance(double d, double[][] dArray, double[][] dArray2, double[][] dArray3) {
        if (this.hasDiagonalActualization()) {
            return this.getJointVarianceDiagonal(d, dArray, dArray2, dArray3);
        }
        return this.getJointVarianceFull(d, dArray, dArray2, dArray3);
    }

    private double[][] getJointVarianceFull(double d, double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        double[] dArray4 = this.getEigenValuesStrengthOfSelection();
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(this.getEigenVectorsStrengthOfSelection(), 0, this.dim, this.dim);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.dim, this.dim);
        CommonOps.invert(denseMatrix64F, denseMatrix64F2);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(dArray3);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dim, this.dim);
        CommonOps.mult(denseMatrix64F2, denseMatrix64F3, denseMatrix64F4);
        CommonOps.multTransB(denseMatrix64F4, denseMatrix64F2, denseMatrix64F3);
        double[][] dArray5 = new double[this.dim][this.dim];
        for (n = 0; n < this.dim; ++n) {
            for (int i = 0; i < this.dim; ++i) {
                dArray5[n][i] = 1.0 / (dArray4[n] + dArray4[i]);
            }
        }
        n = this.tree.getExternalNodeCount();
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(this.dim, this.dim);
        double[][] dArray6 = new double[this.dim * n][this.dim * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2;
                int n3;
                double d2 = dArray2[i][i];
                double d3 = dArray2[j][j];
                double d4 = dArray2[i][j];
                for (n3 = 0; n3 < this.dim; ++n3) {
                    for (n2 = 0; n2 < this.dim; ++n2) {
                        double d5 = dArray4[n3];
                        double d6 = dArray4[n2];
                        denseMatrix64F5.set(n3, n2, Math.exp(-d5 * d2) * Math.exp(-d6 * d3) * (dArray5[n3][n2] * (Math.exp((d5 + d6) * d4) - 1.0) + 1.0 / d) * denseMatrix64F3.get(n3, n2));
                    }
                }
                CommonOps.mult(denseMatrix64F, denseMatrix64F5, denseMatrix64F4);
                CommonOps.multTransB(denseMatrix64F4, denseMatrix64F, denseMatrix64F5);
                for (n3 = 0; n3 < this.dim; ++n3) {
                    for (n2 = 0; n2 < this.dim; ++n2) {
                        dArray6[i * this.dim + n3][j * this.dim + n2] = denseMatrix64F5.get(n3, n2);
                    }
                }
            }
        }
        return dArray6;
    }

    private double[][] getJointVarianceDiagonal(double d, double[][] dArray, double[][] dArray2, double[][] dArray3) {
        double[] dArray4 = this.getEigenValuesStrengthOfSelection();
        int n = this.tree.getExternalNodeCount();
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.dim, this.dim);
        double[][] dArray5 = new double[this.dim * n][this.dim * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2;
                int n3;
                double d2 = dArray2[i][i];
                double d3 = dArray2[j][j];
                double d4 = dArray2[i][j];
                for (n3 = 0; n3 < this.dim; ++n3) {
                    for (n2 = 0; n2 < this.dim; ++n2) {
                        double d5 = dArray4[n3];
                        double d6 = dArray4[n2];
                        double d7 = d5 + d6 == 0.0 ? (d4 + 1.0 / d) * dArray3[n3][n2] : Math.exp(-d5 * d2) * Math.exp(-d6 * d3) * (Math.expm1((d5 + d6) * d4) / (d5 + d6) + 1.0 / d) * dArray3[n3][n2];
                        denseMatrix64F.set(n3, n2, d7);
                    }
                }
                for (n3 = 0; n3 < this.dim; ++n3) {
                    for (n2 = 0; n2 < this.dim; ++n2) {
                        dArray5[i * this.dim + n3][j * this.dim + n2] = denseMatrix64F.get(n3, n2);
                    }
                }
            }
        }
        return dArray5;
    }

    @Override
    public void getMeanTipVariances(double d, double[] dArray, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (this.hasDiagonalActualization()) {
            this.getMeanTipVariancesDiagonal(d, dArray, denseMatrix64F, denseMatrix64F2);
        }
        this.getMeanTipVariancesFull(d, dArray, denseMatrix64F, denseMatrix64F2);
    }

    private void getMeanTipVariancesFull(double d, double[] dArray, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        DenseMatrix64F denseMatrix64F3 = MissingOps.wrap(this.getEigenVectorsStrengthOfSelection(), 0, this.dim, this.dim);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dim, this.dim);
        CommonOps.invert(denseMatrix64F3, denseMatrix64F4);
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(denseMatrix64F);
        DenseMatrix64F denseMatrix64F6 = new DenseMatrix64F(this.dim, this.dim);
        CommonOps.mult(denseMatrix64F4, denseMatrix64F5, denseMatrix64F6);
        CommonOps.multTransB(denseMatrix64F6, denseMatrix64F4, denseMatrix64F5);
        this.getMeanTipVariancesDiagonal(d, dArray, denseMatrix64F5, denseMatrix64F2);
        CommonOps.mult(denseMatrix64F3, denseMatrix64F2, denseMatrix64F6);
        CommonOps.multTransB(denseMatrix64F6, denseMatrix64F3, denseMatrix64F2);
    }

    private void getMeanTipVariancesDiagonal(double d, double[] dArray, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        double[] dArray2 = this.getEigenValuesStrengthOfSelection();
        int n = this.tree.getExternalNodeCount();
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i];
            for (int j = 0; j < this.dim; ++j) {
                double d3 = dArray2[j];
                for (int k = 0; k < this.dim; ++k) {
                    double d4 = dArray2[k];
                    double d5 = d3 + d4 == 0.0 ? (d2 + 1.0 / d) * denseMatrix64F.get(j, k) : Math.exp(-(d3 + d4) * d2) * (Math.expm1((d3 + d4) * d2) / (d3 + d4) + 1.0 / d) * denseMatrix64F.get(j, k);
                    denseMatrix64F2.set(j, k, denseMatrix64F2.get(j, k) + d5);
                }
            }
        }
        CommonOps.scale(1.0 / (double)dArray.length, denseMatrix64F2);
    }
}

