/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

public class LambertW {
    static double M_E = Math.E;
    static double GSL_DBL_EPSILON = 2.220446049250313E-16;
    static final double[] c = new double[]{-1.0, 2.331643981597124, -1.8121878856393634, 1.9366311144923598, -2.3535512018816145, 3.0668589010506317, -4.175335600258177, 5.858023729874774, -8.401032217523978, 12.25075350131446, -18.10069701247244, 27.029044799010563};

    public static GSL_RETURN halley_iteration(double d, double d2, int n, gsl_sf_result gsl_sf_result2) {
        double d3 = d2;
        for (int i = 0; i < n; ++i) {
            double d4 = Math.exp(d3);
            double d5 = d3 + 1.0;
            double d6 = d3 * d4 - d;
            d6 = d3 > 0.0 ? d6 / d5 / d4 : (d6 /= d4 * d5 - 0.5 * (d5 + 1.0) * d6 / d5);
            double d7 = 10.0 * GSL_DBL_EPSILON * Math.max(Math.abs(d3 -= d6), 1.0 / (Math.abs(d5) * d4));
            if (!(Math.abs(d6) < d7)) continue;
            gsl_sf_result2.val = d3;
            gsl_sf_result2.err = 2.0 * d7;
            return GSL_RETURN.GSL_SUCCESS;
        }
        gsl_sf_result2.val = d3;
        gsl_sf_result2.err = Math.abs(d3);
        return GSL_RETURN.GSL_EMAXITER;
    }

    public static double series_eval(double d) {
        double d2 = c[8] + d * (c[9] + d * (c[10] + d * c[11]));
        double d3 = c[5] + d * (c[6] + d * (c[7] + d * d2));
        double d4 = c[1] + d * (c[2] + d * (c[3] + d * (c[4] + d * d3)));
        return c[0] + d * d4;
    }

    static GSL_RETURN gsl_sf_lambert_W0_e(double d, gsl_sf_result gsl_sf_result2) {
        double d2;
        double d3 = 1.0 / M_E;
        double d4 = d + d3;
        if (d == 0.0) {
            gsl_sf_result2.val = 0.0;
            gsl_sf_result2.err = 0.0;
            return GSL_RETURN.GSL_SUCCESS;
        }
        if (d4 < 0.0) {
            gsl_sf_result2.val = -1.0;
            gsl_sf_result2.err = Math.sqrt(-d4);
            return GSL_RETURN.GSL_EDOM;
        }
        if (d4 == 0.0) {
            gsl_sf_result2.val = -1.0;
            gsl_sf_result2.err = GSL_DBL_EPSILON;
            return GSL_RETURN.GSL_SUCCESS;
        }
        if (d4 < 0.001) {
            double d5 = Math.sqrt(d4);
            gsl_sf_result2.val = LambertW.series_eval(d5);
            gsl_sf_result2.err = 2.0 * GSL_DBL_EPSILON * Math.abs(gsl_sf_result2.val);
            return GSL_RETURN.GSL_SUCCESS;
        }
        if (d < 1.0) {
            double d6 = Math.sqrt(2.0 * M_E * d4);
            d2 = -1.0 + d6 * (1.0 + d6 * (-0.3333333333333333 + d6 * 11.0 / 72.0));
        } else {
            d2 = Math.log(d);
            if (d > 3.0) {
                d2 -= Math.log(d2);
            }
        }
        return LambertW.halley_iteration(d, d2, 10, gsl_sf_result2);
    }

    static GSL_RETURN gsl_sf_lambert_Wm1_e(double d, gsl_sf_result gsl_sf_result2) {
        double d2;
        if (d > 0.0) {
            return LambertW.gsl_sf_lambert_W0_e(d, gsl_sf_result2);
        }
        if (d == 0.0) {
            gsl_sf_result2.val = 0.0;
            gsl_sf_result2.err = 0.0;
            return GSL_RETURN.GSL_SUCCESS;
        }
        double d3 = 1.0 / M_E;
        double d4 = d + d3;
        if (d4 < 0.0) {
            gsl_sf_result2.val = -1.0;
            gsl_sf_result2.err = Math.sqrt(-d4);
            return GSL_RETURN.GSL_EDOM;
        }
        if (d < -1.0E-6) {
            double d5 = -Math.sqrt(d4);
            d2 = LambertW.series_eval(d5);
            if (d4 < 0.003) {
                gsl_sf_result2.val = d2;
                gsl_sf_result2.err = 5.0 * GSL_DBL_EPSILON * Math.abs(d2);
                return GSL_RETURN.GSL_SUCCESS;
            }
        } else {
            double d6 = Math.log(-d);
            double d7 = Math.log(-d6);
            d2 = d6 - d7 + d7 / d6;
        }
        return LambertW.halley_iteration(d, d2, 32, gsl_sf_result2);
    }

    public static double branch0(double d) {
        gsl_sf_result gsl_sf_result2 = new gsl_sf_result();
        GSL_RETURN gSL_RETURN = LambertW.gsl_sf_lambert_W0_e(d, gsl_sf_result2);
        if (gSL_RETURN == GSL_RETURN.GSL_EMAXITER) {
            throw new RuntimeException("Too many iterations");
        }
        return gsl_sf_result2.val;
    }

    public static double branchNeg1(double d) {
        gsl_sf_result gsl_sf_result2 = new gsl_sf_result();
        GSL_RETURN gSL_RETURN = LambertW.gsl_sf_lambert_Wm1_e(d, gsl_sf_result2);
        if (gSL_RETURN == GSL_RETURN.GSL_EMAXITER) {
            throw new RuntimeException("Too many iterations");
        }
        return gsl_sf_result2.val;
    }

    public static enum GSL_RETURN {
        GSL_SUCCESS,
        GSL_EMAXITER,
        GSL_EDOM;

    }

    public static class gsl_sf_result {
        public double val = 0.0;
        public double err = 0.0;
    }
}

